<?php

class User
{
	function user_pages($q)
	{
		global $module, $modules;
		
		if(empty($q[1]) or is_numeric($q[1]))
		{
			$modules->include_language("user");
			
			if($this->is_authorized())
			{
				if(count($q) > 1)
				{
					include("modules/user/userinfo.php");
					$result = userinfo_page();
				}else{
					include("modules/user/profile.php");
					$result = profile_page();
				}
			}else{
				$temp = $modules->load_template("modules/user/temp/login.tpl");
				$temp = eval("return '$temp';");
				$result["title"] = LOGIN;
				$result["content"] = $temp;
			}
		}else{
			switch($q[1])
			{
				case("signup");
					include("modules/user/signup.php");
					$result = signup_page();
				break;
				
				case("forgotpw");
					include("modules/user/forgotpw.php");
					$result = forgotpw_page();
				break;
				
				case("changeemail");
					include("modules/user/changeemail.php");
					$result = changeemail_page();
				break;
				
				case("login");
					include("modules/user/login.php");
					$result = login_page();
				break;
				
				case("logout");
					if($this->is_authorized())
					{
						$this->logout();
					}
					header("Location: ".$_SERVER["HTTP_REFERER"]);
				break;
			}
		}
		
		return $result;
	}
	
	function user_block()
	{
		global $module;
		
		if($this->is_authorized())
		{
			return $this->menu();
		}else{
			$q = get_query();
			$q = implode("/", $q);
			if(substr($q, 0, 4) != "user" or $q == "user/login")
			{
				return $this->user_login_form();
			}
		}
	}
	
	function user_login_form()
	{
		global $modules;
		
		$modules->include_language("user");
		$temp = $modules->load_template("modules/user/temp/login_block.tpl");
		return eval("return '$temp';");
	}

	function is_authorized()
	{
		global $db;

		$result = false;
		start_session_now();
		if((!isset($_SESSION["_user"]) and !isset($_SESSION["_pass"])) and (isset($_COOKIE["_user"]) and isset($_COOKIE["_pass"])))
		{
			$user = query_filter($_COOKIE["_user"]);
			
			$_SESSION["_user"] = $user;
			$_SESSION["_pass"] = $_COOKIE["_pass"];
		}
		if(isset($_SESSION["_user"]) and isset($_SESSION["_pass"]))
		{
			$user = $_SESSION["_user"];
			$pass = $_SESSION["_pass"];

			$query = $db->select("pass", "users", "WHERE user='$user'");
			if($login = $db->fetch_array($query))
			{
				if($login["pass"] == $pass)
				{
					$result = true;
				}
			}
		}
		return $result;
	}

	function login($user, $pass, $keepme = 0)
	{
		global $db;

		$result = false;
		$user = query_filter($user);
		
		$user_password = $this->get_user_info("pass", $user);
		if($user_password == md5($pass))
		{
			start_session_now();
			$_SESSION["_user"] = $user;
			$_SESSION["_pass"] = md5($pass);
			if($keepme == 1)
			{
				setcookie("_user", $user, time()+604800, '/');
				setcookie("_pass", md5($pass), time()+604800, '/');
			}
			$date = getdate();
			$db->update("users", "signedin='".$date[0]."', ipaddr='".$_SERVER["REMOTE_ADDR"]."' WHERE user='$user'");
			$result = true;
		}
		return $result;
	}

	function logout()
	{
		start_session_now();
		setcookie("_user", "", time()-604800, '/');
		setcookie("_pass", "", time()-604800, '/');
		unset($_COOKIE["_user"]);
		unset($_COOKIE["_pass"]);
		unset($_SESSION["_user"]);
		unset($_SESSION["_pass"]);
	}

	function user_block_title()
	{
		if($this->is_authorized())
		{
			global $module;
			return $module["user"]->get_user_info("user");
		}else{
			global $modules;
			$modules->include_language("user");
			return LOGIN;
		}
	}
	
	function get_user_info($field = "", $username = "")
	{
		global $db;
		
		if(empty($username))
		{
			start_session_now();
			$username = @$_SESSION["_user"];
		}
		
		$result = false;
		
		if(empty($field))
		{
			$query = $db->select("*", "users", "WHERE user='$username'");
			if($user = $db->fetch_array($query))
			{
				$result = $user;
			}
		}else{
			$query = $db->select("`$field`", "users", "WHERE user='$username'");
			if($user = $db->fetch_array($query))
			{
				$result = $user[$field];
			}
		}
		
		return $result;
	}
	
	function user_exists($user)
	{
		global $db;
		
		$user = query_filter($user);
		$query = $db->select("id", "users", "WHERE user='$user'");
		if($db->fetch_array($query))
		{
			return true;
		}else{
			return false;
		}
	}
	
	function email_exists($email)
	{
		global $db;
		
		$user = query_filter($email);
		$query = $db->select("id", "users", "WHERE email='$email'");
		if($db->fetch_array($query))
		{
			return true;
		}else{
			return false;
		}
	}
	
	function get_options()
	{
		global $db;
		
		$query = $db->select("*", "user");
		while($option = $db->fetch_array($query))
		{
			$options[$option["name"]] = $option["value"];
		}
		return $options;
	}
	
	function get_member_for($signedup, $count = 2)
	{
		$array = array_reverse(get_time_difference(date("Y-m-d H:i:s", $signedup)));
		$units = array("year", "month", "day", "hour", "minute", "second");
		$data = "";
		$which = 0;
		foreach($units as $value)
		{
			if($array[$value] != 0 or $which > 0)
			{
				if($array[$value] != 0)
				{
					if($array[$value] != 1) { $s = "s"; }else{ $s = ""; }
					$data .= $array[$value]." ".eval("return ".strtoupper($value.$s).";")." ";
				}
				$which++;
			}
			if($which == $count) { break; }
		}
		
		return substr($data, 0, strlen($data)-1);
	}
	
	function get_last_login($signedin, $count = 2)
	{
		if($signedin == 0)
		{
			return NEVER;
		}else{
			$array = array_reverse(get_time_difference(date("Y-m-d H:i:s", $signedin)));
			$units = array("year", "month", "day", "hour", "minute", "second");
			$data = "";
			$which = 0;
			foreach($units as $value)
			{
				if($array[$value] != 0 or $which > 0)
				{
					if($array[$value] != 0)
					{
						if($array[$value] != 1) { $s = "s"; }else{ $s = ""; }
						$data .= $array[$value]." ".eval("return ".strtoupper($value.$s).";")." ";
					}
					$which++;
				}
				if($which == $count) { break; }
			}
			return substr($data, 0, strlen($data)-1)." ".AGO;
		}
	}
	
	function num_of_users($arguments = "")
	{
		global $db;
		
		$query = $db->select("id", "users", $arguments);
		$num_of_users = $db->num_rows($query);
		return $num_of_users;
	}
	
	function get_user_language()
	{
		global $module;
		
		$language = $this->get_user_info("language");
		
		if(isset($_GET["q"]))
		{
			$default = $module["language"]->get_language();
			if(!empty($default))
			{
				$language = $default;
			}
		}
		
		return $language;
	}
	
	function menu()
	{
		global $db, $page, $module, $settings;
		
		$template = $this->load_menu_template();
		
		$items = "";
		$query = $db->select("*", "menu", "ORDER BY id ASC");
		while($item = $db->fetch_array($query))
		{
			if(($item["language"] == "all" or in_array($page["language"], explode(",", $item["language"]))))
			{
				if($item["usergroup"] == "everyone" or ($module["user"]->is_authorized() and in_array($module["user"]->get_user_info("usergroup"), explode(",", $item["usergroup"]))))
				{
					if(substr($item["href"], 0, 3) == "[q=" and substr($item["href"], strlen($item["href"])-1, strlen($item["href"])) == "]"){ $href = substr($item["href"], 3, strlen($item["href"])-4); if(empty($href)){ $item["href"] = $settings["site"]; }else{ $item["href"] = url($href); } }
					$items .= eval("return '".$template["item"]."';");
				}
			}
		}
		
		return $template["start"].$items.$template["end"];
	}
	
	function load_menu_template()
	{
		global $modules;
		
		$template_file = $modules->load_template("modules/user/menu.tpl");
		
		$item["start"] = strpos($template_file, "<!--START-->");
		$item["end"] = strpos(substr($template_file, $item["start"], strlen($template_file)), "<!--END-->");
		
		$template["item"] = substr($template_file, $item["start"] + 12, $item["end"] - 12);
		$template["start"] = trim(substr($template_file, 0, strpos($template_file, "<!--START-->")));
		$template["end"] = trim(substr($template_file, strpos($template_file, "<!--END-->")+10, strlen($template_file)));
		
		return $template;
	}
	
	function load_menu_style()
	{
		global $modules;
		
		return $modules->get_style("user", "menu.css");
	}
}

?>