<?php

function signup_page()
{
	global $module, $modules;
	
	$modules->include_language("user");
	$options = $module["user"]->get_options();
	
	if(!$module["user"]->is_authorized())
	{
		if($options["signup"] == 1)
		{
			if($modules->is_installed("captcha"))
			{
				$captcha = $module["captcha"]->captcha();
				$result["head"] = $captcha["head"];
				$captcha["content"] = '<tr><td colspan="2">&nbsp;</td></tr><tr><td valign="top">'.CAPTCHA.':</td><td>'.$captcha["content"].'</td></tr>';
			}
			
			if($options["emailconfirm"] == 1)
			{
				$q = get_query();
				if(count($q) > 2)
				{
					if($q[2] != "sent")
					{
						$message = signup_confirm_1($q);
						$table = $modules->load_template("modules/user/temp/signup_confirm_1.tpl");
					}else{
						$table = '<div class="message"><ul><li>'.MSG22.'</li></ul></div>';
					}
				}else{
					$message = signup_confirm_0();
					$table = $modules->load_template("modules/user/temp/signup_confirm_0.tpl");
				}
				
				$table = eval("return '$table';");
				$result["title"] = SIGN_UP;
				$result["content"] = $table;
			}else{
				$message = signup_simple();
				$result["title"] = SIGN_UP;
				$result["content"] = $modules->load_template("modules/user/temp/signup_simple.tpl");
				$result["content"] = eval("return '".$result["content"]."';");
			}
		}else{
			$result["title"] = SIGN_UP;
			$result["content"] = '<div class="message"><ul><li>'.MSG20.' <a href="'.$_SERVER["HTTP_REFERER"].'">['.BACK.']</a></li></ul></div>';
		}
	}else{
		$result["title"] = SIGN_UP;
		$result["content"] = '<div class="message"><ul><li>'.MSG19.' <a href="'.$_SERVER["HTTP_REFERER"].'">['.BACK.']</a></li></ul></div>';
	}
	
	return $result;
}

function signup_simple()
{
	global $db, $module, $modules, $settings;
	
	if(isset($_POST["submit"]))
	{
		$fields = array("user", "pass", "confirmpass", "email");
		foreach($fields as $value)
		{
			$form[$value] = @$_POST[$value];
		}
		
		$errors = array();
		if(empty($form["user"]))
		{
			array_push($errors, "MSG3");
		}else{
			if(strlen($form["user"]) < 3)
			{
				array_push($errors, "MSG4");
			}else{
				if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))([a-z0-9])*$/i" , $form["user"]))
				{
					array_push($errors, "MSG5");
				}else{
					if($module["user"]->user_exists($form["user"]) == true)
					{
						array_push($errors, "MSG6");
					}
				}
			}
		}
		
		if(empty($form["pass"]))
		{
			array_push($errors, "MSG7");
		}else{
			if(strlen($form["pass"]) < 6)
			{
				array_push($errors, "MSG8");
			}else{
				if(preg_match("/[(<)(>)]/", $form["pass"]))
				{
					array_push($errors, "MSG9");
				}else{
					if($form["pass"] != $form["confirmpass"])
					{
						array_push($errors, "MSG10");
					}
				}
			}
		}
		
		if(empty($form["email"]))
		{
			array_push($errors, "MSG11");
		}else{
			if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))*\@([a-z0-9])*(\.([a-z0-9])([-a-z0-9_-])([a-z0-9])+)*$/i", $form["email"]))
			{
				array_push($errors, "MSG12");
			}else{
				if($module["user"]->email_exists($form["email"]) == true)
				{
					array_push($errors, "MSG13");
				}
			}
		}
		
		if($modules->is_installed("captcha"))
		{
			if(!$module["captcha"]->check_captcha($_POST["captcha"]))
			{
				array_push($errors, "MSG32");
			}
		}
		
		if(count($errors) < 1)
		{
			$date = getdate();
			$code = md5($user["user"].$data[0].rand(0, 999));
			$options = $module["user"]->get_options();
			
			$db->insert("users", "('', '".$form["user"]."', '".md5($form["pass"])."', '".$form["email"]."', '', '".$settings["language"]."', '".$settings["theme"]."', '".$date[0]."', '0', '', '1', '".$options["defaultusergroup"]."')");
			
			$subject = $options["welcomeemailsubject"];
			$message = str_filter("{USERNAME},{SITE},{PASSWORD},{LOGIN_URL}", $form["user"].',<a href="'.$settings["site"].'">'.$settings["title"].'</a>,'.$form["pass"].',<a href="'.url("user", 1).'">'.url("user", 1).'</a>', $options["welcomeemailmessage"]);
			mail($form["email"], $subject, nl2br($message), "MIME-Version: 1.0\r\nContent-type: text/html; charset=utf-8\r\nFrom: ".$settings["email"]);
			
			$table = '<div class="message"><ul><li>'.MSG21.' <a href="'.url("user").'">['.LOGIN.']</a></li></ul></div><br />';
		}else{
			$table = '<div class="message"><ul>';
			foreach($errors as $value)
			{
				$table .= '<li>'.eval("return $value;").'</li>';
			}
			$table .= '</ul></div><br />';
		}
		
		return $table;
	}
}

function signup_confirm_0()
{
	global $db, $module, $modules, $settings;
	
	$table = "";
	
	if(isset($_POST["submit"]))
	{
		$fields = array("user", "email");
		foreach($fields as $value)
		{
			$form[$value] = @$_POST[$value];
		}
		
		$errors = array();
		if(empty($form["user"]))
		{
			array_push($errors, "MSG3");
		}else{
			if(strlen($form["user"]) < 3)
			{
				array_push($errors, "MSG4");
			}else{
				if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))([a-z0-9])*$/i" , $form["user"]))
				{
					array_push($errors, "MSG5");
				}else{
					if($module["user"]->user_exists($form["user"]) == true)
					{
						array_push($errors, "MSG6");
					}
				}
			}
		}
		
		if(empty($form["email"]))
		{
			array_push($errors, "MSG11");
		}else{
			if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))*\@([a-z0-9])*(\.([a-z0-9])([-a-z0-9_-])([a-z0-9])+)*$/i", $form["email"]))
			{
				array_push($errors, "MSG12");
			}else{
				if($module["user"]->email_exists($form["email"]) == true)
				{
					array_push($errors, "MSG13");
				}
			}
		}
		
		if($modules->is_installed("captcha"))
		{
			if(!$module["captcha"]->check_captcha($_POST["captcha"]))
			{
				array_push($errors, "MSG32");
			}
		}
		
		if(count($errors) < 1)
		{
			$date = getdate();
			$code = md5($user["user"].$date[0].rand(0, 999));
			$options = $module["user"]->get_options();
			
			$subject = $options["activationemailsubject"];
			$message = str_filter("{USERNAME},{SITE},{ACTIVATION_URL}", $form["user"].',<a href="'.$settings["site"].'">'.$settings["title"].'</a>,<a href="'.url("user/signup", 1).'/'.$code.'">'.url("user/signup", 1).'/'.$code.'</a>', $options["activationemailmessage"]);
			
			$db->insert("signup", "('', '".$form["user"]."', '".$form["email"]."', '".$code."', '".($date[0]+86400)."')");
			mail($form["email"], $subject, nl2br($message), "MIME-Version: 1.0\r\nContent-type: text/html; charset=utf-8\r\nFrom: ".$settings["email"]);
			header("Location: ".url("user/signup/sent"));
		}else{
			$table = '<div class="message"><ul>';
			foreach($errors as $value)
			{
				$table .= '<li>'.eval("return $value;").'</li>';
			}
			$table .= '</ul></div><br />';
		}
		
		return $table;
	}
}

function signup_confirm_1($q)
{
	global $db, $module, $settings;
	
	$success = false;
	$code = query_filter($q[2]);
	$query = $db->select("*", "signup", "WHERE code='$code'");
	if($signup = $db->fetch_array($query))
	{
		$table = "";
		
		$date = getdate();
		if($signup["expire"] > $date[0])
		{
			if(isset($_POST["submit"]))
			{
				$fields = array("pass", "confirmpass");
				foreach($fields as $value)
				{
					$form[$value] = @$_POST[$value];
				}
				
				$errors = array();
				if(empty($form["pass"]))
				{
					array_push($errors, "MSG7");
				}else{
					if(strlen($form["pass"]) < 6)
					{
						array_push($errors, "MSG8");
					}else{
						if(preg_match("/[(<)(>)]/", $form["pass"]))
						{
							array_push($errors, "MSG9");
						}else{
							if($form["pass"] != $form["confirmpass"])
							{
								array_push($errors, "MSG10");
							}
						}
					}
				}
				
				if(count($errors) < 1)
				{
					$date = getdate();
					$options = $module["user"]->get_options();
					
					$db->insert("users", "('', '".$signup["user"]."', '".md5($form["pass"])."', '".$signup["email"]."', '', '".$settings["language"]."', '".$settings["theme"]."', '".$date[0]."', '0', '', '1', '".$options["defaultusergroup"]."')");
					$db->delete("signup", "WHERE code='$code'");
					
					$table = '<div class="message"><ul><li>'.MSG21.' <a href="'.url("user").'">['.LOGIN.']</a></li></ul></div><br />';
					
					$subject = $options["welcomeemailsubject"];
					$message = str_filter("{USERNAME},{SITE},{PASSWORD},{LOGIN_URL}", $signup["user"].',<a href="'.$settings["site"].'">'.$settings["title"].'</a>,'.$form["pass"].',<a href="'.url("user", 1).'">'.url("user", 1).'</a>', $options["welcomeemailmessage"]);
					mail($signup["email"], $subject, nl2br($message), "MIME-Version: 1.0\r\nContent-type: text/html; charset=utf-8\r\nFrom: ".$settings["email"]);
					$success =true;
				}else{
					$table = '<div class="message"><ul>';
					foreach($errors as $value)
					{
						$table .= '<li>'.eval("return $value;").'</li>';
					}
					$table .= '</ul></div><br />';
				}
			}
			
			if(!$success)
			{
				$table .= '<form name="signup" action="'.url("user/signup/".$code).'" method="post">';
				$table .= '<table>';
				$table .= '<tr><td>'.USERNAME.':</td><td><input name="user" type="text" maxlength="64" value="'.$signup["user"].'" disabled="disabled" /></td></tr>';
				$table .= '<tr><td>'.EMAIL.':</td><td><input name="email" type="text" maxlength="128" value="'.$signup["email"].'" disabled="disabled" /></td></tr>';
				$table .= '<tr><td>&nbsp;</td><td><hr size="1" /></td></tr>';
				$table .= '<tr><td>'.PASSWORD.':</td><td><input name="pass" type="password" maxlength="64" value="" /></td></tr>';
				$table .= '<tr><td>'.CONFIRM_PASSWORD.':</td><td><input name="confirmpass" type="password" maxlength="64" value="" /></td></tr>';
				$table .= '<tr><td colspan="2">&nbsp;</td></tr>';
				$table .= '<tr><td>&nbsp;</td><td><button name="submit" type="submit">'.SIGN_UP.'</button> <button name="reset" type="reset">'.RESET.'</button></td></tr>';
				$table .= '</table>';
				$table .= '</form>';
			}
		}else{
			$table = '<div class="message"><ul><li>'.MSG24.'</li></ul></div><br />';
		}
	}else{
		$table = '<div class="message"><ul><li>'.MSG23.'</li></ul></div><br />';
	}
	
	return $table;
}

?>