<?php

function profile_page()
{
	global $db, $module, $modules, $settings;
	
	include("includes/files.inc");
	$modules->include_language("user");
	
	$changeemail = false;
	$options = $module["user"]->get_options();
	$editable_fields = $options["editablefields"];
	
	if(!empty($editable_fields))
	{
		$editable_fields = explode(",", $editable_fields);
		
		$username = $_SESSION["_user"];
		$query = $db->select("*", "users", "WHERE user='$username'");
		if($user = $db->fetch_array($query))
		{
			if(isset($_POST["submit"]))
			{
				if(!is_refered_from("user")) { exit; }
				
				$fields = array("user", "pass", "confirmpass", "theme", "language", "usergroup", "email", "status");
				foreach($fields as $value)
				{
					if(in_array($value, $editable_fields))
					{
						$form[$value] = @$_POST[$value];
						if($value == "pass")
						{
							$form["confirmpass"] = @$_POST["confirmpass"];
						}
						$field[$value] = true;
					}else{
						$field[$value] = false;
					}
				}
				
				$errors = array();
				if($field["user"])
				{
					if(empty($form["user"]))
					{
						array_push($errors, "MSG3");
					}else{
						if(strlen($form["user"]) < 3)
						{
							array_push($errors, "MSG4");
						}else{
							if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))([a-z0-9])*$/i" , $form["user"]))
							{
								array_push($errors, "MSG5");
							}else{
								if($form["user"] != $user["user"])
								{
									if($module["user"]->user_exists($form["user"]) == true)
									{
										array_push($errors, "MSG6");
									}
								}
							}
						}
					}
				}
				
				if($field["pass"])
				{
					if(!empty($form["pass"]))
					{
						if(strlen($form["pass"]) < 6)
						{
							array_push($errors, "MSG8");
						}else{
							if(preg_match("/[(<)(>)]/", $form["pass"]))
							{
								array_push($errors, "MSG9");
							}else{
								if($form["pass"] != $form["confirmpass"])
								{
									array_push($errors, "MSG10");
								}
							}
						}
					}
				}
				
				if($field["email"])
				{
					if(empty($form["email"]))
					{
						array_push($errors, "MSG11");
					}else{
						if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))*\@([a-z0-9])*(\.([a-z0-9])([-a-z0-9_-])([a-z0-9])+)*$/i", $form["email"]))
						{
							array_push($errors, "MSG12");
						}else{
							if($form["email"] != $user["email"])
							{
								if($module["user"]->email_exists($form["email"]) == true)
								{
									array_push($errors, "MSG13");
								}else{
									if($options["emailconfirm"] == 1)
									{
										$changeemail = true;
									}
								}
							}
						}
					}
				}
				
				if(isset($_FILES["picture"]))
				{
					$upload_picture = false;
					$picture = $_FILES["picture"];
					if(!empty($picture["name"]))
					{
						$options = $module["user"]->get_options();
						$extension = get_file_extension(strtolower($picture["name"]));
						$picture_exts = explode(",", $options["pictureexts"]);
						if(in_array($extension, $picture_exts))
						{
							if($picture["size"] < $options["picturemaxfilesize"])
							{
								$picture_maxsize = explode("x", $options["picturemaxsize"]);
								$picture_size = getimagesize($picture["tmp_name"]);
								if($picture_size[0] <= $picture_maxsize[0] and $picture_size[1] <= $picture_maxsize[1])
								{
									$upload_picture = true;
								}else{
									array_push($errors, "MSG16");
								}
							}else{
								array_push($errors, "MSG15");
							}
						}else{
							array_push($errors, "MSG14");
						}
					}
				}
				
				if(count($errors) < 1)
				{
					$date = getdate();
					if(empty($form["pass"]))
					{
						$form["pass"] = $user["pass"];
					}else{
						$form["pass"] = md5($form["pass"]);
					}
					if($upload_picture == true)
					{
						if(!empty($user["picture"]))
						{
							if(file_exists("uploads/".$user["picture"]))
							{
								unlink("uploads/".$user["picture"]);
							}
						}
						$file_name = md5($date[0]).".".$extension;
						move_uploaded_file($picture['tmp_name'], "./uploads/".$file_name);
					}else{
						$file_name = "";
						if(isset($_POST["removepicture"]))
						{
							if(!empty($user["picture"]))
							{
								if(file_exists("uploads/".$user["picture"]))
								{
									unlink("uploads/".$user["picture"]);
								}
							}
						}else{
							$file_name = $user["picture"];
						}
					}
					if($changeemail)
					{
						$code = md5($user["user"].$date[0].rand(0, 999));
						$options = $module["user"]->get_options();
						
						$emailsubject = $options["changeemailsubject"];
						$emailmessage = str_filter("{USERNAME},{SITE},{ACTIVATION_URL}", $user["user"].',<a href="'.$settings["site"].'">'.$settings["title"].'</a>,<a href="'.url("user/changeemail", 1).'/'.$code.'">'.url("user/changeemail", 1).'/'.$code.'</a>', $options["changeemailmessage"]);
						$add_request = $db->insert("changeemail", "('', '".$user["user"]."', '".$form["email"]."', '".$code."', '".($date[0]+86400)."')");
						mail($form["email"], $emailsubject, nl2br($emailmessage), "MIME-Version: 1.0\r\nContent-type: text/html; charset=utf-8\r\nFrom: ".$settings["email"]);
						$form["email"] = $user["email"];
						$changeemail_message = '<li>'.MSG33.'</li>';
					}else{
						$changeemail_message = "";
					}
					
					foreach($editable_fields as $value)
					{
						if($value != "picture")
						{
							$db->update("users", "$value='".query_filter($form[$value])."' WHERE id='".$user["id"]."'");
						}
					}
					$file_name = query_filter($file_name);
					$db->update("users", "picture='$file_name' WHERE id='".$user["id"]."'");
					unset($form);
					unset($picture);
					$message = '<div class="message"><ul><li>'.MSG18.'</li>'.$changeemail_message.'</ul></div><br />';
				}else{
					$message = '<div class="message"><ul>';
					foreach($errors as $value)
					{
						$message .= '<li>'.eval("return $value;").'</li>';
					}
					$message .= '</ul></div><br />';
				}
				unset($field);
				unset($fields);
			}else{
				$message = "";
			}
		}
		unset($user);
		
		$query = $db->select("*", "users", "WHERE user='$username'");
		if($user = $db->fetch_array($query))
		{
			$themes = "";
			$themes_list = $module["theme"]->get_themes_list("installed");
			foreach($themes_list as $value)
			{
				$theme_info = $module["theme"]->get_theme_info($value);
				if($value == $user["theme"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
				$themes .= '<option value="'.$value.'"'.$selected.'>'.$theme_info["name"].'</option>';
			}
			
			$languages = "";
			$languages_list = $module["language"]->get_languages_list("installed");
			foreach($languages_list as $value)
			{
				$language_info = $module["language"]->get_language_info($value);
				if($value == $user["language"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
				$languages .= '<option value="'.$value.'"'.$selected.'>'.$language_info["name"].'</option>';
			}
			
			$usergroups = "";
			$usergroups_list = $module["usergroup"]->get_usergroups_list();
			foreach($usergroups_list as $key => $value)
			{
				if($key == $user["usergroup"]) { $selected = ' selected="selected"'; }else{ $selected = "";}
				$usergroups .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
			}
			
			$picture = "";
			if(!empty($user["picture"]))
			{
				if(file_exists("uploads/".$user["picture"]))
				{
					$picture = '<img src="'.base_path().'/uploads/'.$user["picture"].'" alt="'.$user["user"].'" /> <label><input name="removepicture" type="checkbox" value="1" />'.REMOVE_PICTURE.'</label><br />';
				}
			}
			
			if($user["status"] == 0)
			{
				$status = '<option value="1">'.ACTIVE.'</option><option value="0" selected="selected">'.BLOCKED.'</option>';
			}else{
				$status = '<option value="1" selected="selected">'.ACTIVE.'</option><option value="0">'.BLOCKED.'</option>';
			}
			
			$field["user"] = '<tr><td>'.USERNAME.':</td><td><input name="user" type="text" maxlength="64" value="'.$_SESSION["_user"].'" /></td></tr>';
			$field["pass"] = '<tr><td>'.PASSWORD.':</td><td><input name="pass" type="password" maxlength="64" value="" /></td></tr><tr><td>'.CONFIRM_PASSWORD.':</td><td><input name="confirmpass" type="password" maxlength="64" value="" /></td></tr><tr><td colspan="2"><hr size="1" /></td></tr>';
			$field["theme"] = '<tr><td>'.THEME.':</td><td><select name="theme">'.$themes.'</select></td></tr>';
			$field["language"] = '<tr><td>'.LANGUAGE.':</td><td><select name="language">'.$languages.'</select></td></tr>';
			$field["usergroup"] = '<tr><td>'.USERGROUP.':</td><td><select name="usergroup">'.$usergroups.'</select></td></tr><tr><td colspan="2"><hr size="1" /></td></tr>';
			$field["email"] = '<tr><td>'.EMAIL.':</td><td><input name="email" type="text" maxlength="128" value="'.$user["email"].'" /></td></tr>';
			$field["picture"] = '<tr><td valign="bottom">'.PICTURE.':</td><td>'.$picture.'<input name="picture" type="file" value="" /></td></tr><tr><td colspan="2"><hr size="1" /></td></tr>';
			$field["status"] = '<tr><td>'.STATUS.':</td><td><select name="status">'.$status.'</select></td></tr><tr><td colspan="2">&nbsp;</td></tr>';
			
			$fields = "";
			foreach($editable_fields as $value)
			{
				$fields .= $field[$value];
			}
			
			$result["title"] = PROFILE;
			$result["content"] = '<h2>'.PROFILE.'</h2><br />'.$message.'<form name="profile" action="" method="post" enctype="multipart/form-data"><table>'.$fields.'<tr><td colspan="2"><button name="submit" type="submit">'.SAVE.'</button> <button type="reset">'.RESET.'</button></td></tr></table></form>';
			return $result;
		}
	}
}

?>