<?php

function administration()
{
	global $db, $settings, $module, $modules;
	
	$modules->include_language("user");
	$q = get_query();
	
	if(empty($q[3]))
	{
		$class = array("new" => "selected", "menu" => "tab", "list" => "tab", "options" => "tab");
		header("Location: ".url("admin/modules/user/new"));
	}else{
		$head = "";
		
		switch($q[3])
		{
			case("new");
				include("includes/files.inc");
				$class = array("new" => "selected", "menu" => "tab", "list" => "tab", "options" => "tab");
				
				$table = "";
				$form = array("user" => "", "email" => "");
				$result = array("head" => "", "content" => "");
				
				if(isset($_POST["submit"]))
				{
					if(!is_refered_from("admin/modules/user/new")) { exit; }
					
					$fields = array("user", "pass", "confirmpass", "theme", "language", "usergroup", "email");
					foreach($fields as $value)
					{
						$form[$value] = @$_POST[$value];
					}
					
					$errors = array();
					if(empty($form["user"]))
					{
						array_push($errors, "MSG3");
					}else{
						if(strlen($form["user"]) < 3)
						{
							array_push($errors, "MSG4");
						}else{
							if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))([a-z0-9])*$/i" , $form["user"]))
							{
								array_push($errors, "MSG5");
							}else{
								if($module["user"]->user_exists($form["user"]) == true)
								{
									array_push($errors, "MSG6");
								}
							}
						}
					}
					if(empty($form["pass"]))
					{
						array_push($errors, "MSG7");
					}else{
						if(strlen($form["pass"]) < 6)
						{
							array_push($errors, "MSG8");
						}else{
							if(preg_match("/[(<)(>)]/", $form["pass"]))
							{
								array_push($errors, "MSG9");
							}else{
								if($form["pass"] != $form["confirmpass"])
								{
									array_push($errors, "MSG10");
								}
							}
						}
					}
					if(empty($form["email"]))
					{
						array_push($errors, "MSG11");
					}else{
						if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))*\@([a-z0-9])*(\.([a-z0-9])([-a-z0-9_-])([a-z0-9])+)*$/i", $form["email"]))
						{
							array_push($errors, "MSG12");
						}else{
							if($module["user"]->email_exists($form["email"]) == true)
							{
								array_push($errors, "MSG13");
							}
						}
					}
					if(isset($_FILES["picture"]))
					{
						$upload_picture = false;
						$picture = $_FILES["picture"];
						if(!empty($picture["name"]))
						{
							$options = $module["user"]->get_options();
							$extension = get_file_extension(strtolower($picture["name"]));
							$picture_exts = explode(",", $options["pictureexts"]);
							if(in_array($extension, $picture_exts))
							{
								if($picture["size"] < $options["picturemaxfilesize"])
								{
									$picture_maxsize = explode("x", $options["picturemaxsize"]);
									$picture_size = getimagesize($picture["tmp_name"]);
									if($picture_size[0] <= $picture_maxsize[0] and $picture_size[1] <= $picture_maxsize[1])
									{
										$upload_picture = true;
									}else{
										array_push($errors, "MSG16");
									}
								}else{
									array_push($errors, "MSG15");
								}
							}else{
								array_push($errors, "MSG14");
							}
						}
					}
					
					if(count($errors) < 1)
					{
						$date = getdate();
						if($upload_picture == true)
						{
							$file_name = md5($date[0]).".".$extension;
							move_uploaded_file($picture['tmp_name'], "./uploads/".$file_name);
						}
						$db->insert("users", "('', '".$form["user"]."', '".md5($form["pass"])."', '".$form["email"]."', '".$file_name."', '".$form["language"]."', '".$form["theme"]."', '".$date[0]."', '0', '', '1', '".$form["usergroup"]."')");
						unset($form);
						$table .= '<div class="message"><ul><li>'.MSG17.'</li></ul></div><br />';
					}else{
						$table .= '<div class="message"><ul>';
						foreach($errors as $value)
						{
							$table .= '<li>'.eval("return $value;").'</li>';
						}
						$table .= '</ul></div><br />';
					}
				}
				
				$themes = "";
				$themes_list = $module["theme"]->get_themes_list("installed");
				foreach($themes_list as $value)
				{
					$theme_info = $module["theme"]->get_theme_info($value);
					if($value == $settings["theme"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
					$themes .= '<option value="'.$value.'"'.$selected.'>'.$theme_info["name"].'</option>';
				}
				
				$languages = "";
				$languages_list = $module["language"]->get_languages_list("installed");
				foreach($languages_list as $value)
				{
					$language_info = $module["language"]->get_language_info($value);
					if($value == $settings["language"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
					$languages .= '<option value="'.$value.'"'.$selected.'>'.$language_info["name"].'</option>';
				}
				
				$options = $module["user"]->get_options();
				
				$usergroups = "";
				$usergroups_list = $module["usergroup"]->get_usergroups_list();
				foreach($usergroups_list as $key => $value)
				{
					if($key == $options["defaultusergroup"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
					$usergroups .= '<option value="'.$value.'"'.$selected.'>'.$value.'</option>';
				}
				
				$print["user"] = str_filter("<,>,\"", "&lt;,&gt;,&quot;", $form["user"]);
				$print["email"] = str_filter("<,>,\"", "&lt;,&gt;,&quot;", $form["email"]);
				
				$table .= '<form name="add_user" action="'.url("admin/modules/user/new").'" method="post" enctype="multipart/form-data">';
				$table .= '<table>';
				$table .= '<tr><td>'.USERNAME.':</td><td><input name="user" type="text" maxlength="64" value="'.$print["user"].'" /></td></tr>';
				$table .= '<tr><td>'.PASSWORD.':</td><td><input name="pass" type="password" maxlength="64" value="" /></td></tr>';
				$table .= '<tr><td>'.CONFIRM_PASSWORD.':</td><td><input name="confirmpass" type="password" maxlength="64" value="" /></td></tr>';
				$table .= '<tr><td colspan="2"><hr size="1" /></td></tr>';
				$table .= '<tr><td>'.THEME.':</td><td><select name="theme">'.$themes.'</select></td></tr>';
				$table .= '<tr><td>'.LANGUAGE.':</td><td><select name="language">'.$languages.'</select></td></tr>';
				$table .= '<tr><td>'.USERGROUP.':</td><td><select name="usergroup">'.$usergroups.'</select></td></tr>';
				$table .= '<tr><td colspan="2"><hr size="1" /></td></tr>';
				$table .= '<tr><td>'.EMAIL.':</td><td><input name="email" type="text" maxlength="128" value="'.$print["email"].'" /></td></tr>';
				$table .= '<tr><td>'.PICTURE.':</td><td><input name="picture" type="file" value="" /></td></tr>';
				$table .= '<tr><td colspan="2">&nbsp;</td></tr>';
				$table .= '<tr><td colspan="2"><button name="submit" type="submit">'.SAVE.'</button> <button type="reset">'.RESET.'</button></td></tr>';
				$table .= '</table>';
				$table .= '</form>';
			break;
			
			case("menu");
				$class = array("new" => "tab", "menu" => "selected", "list" => "tab", "options" => "tab");
				
				if(empty($q[4]))
				{
					$table = '<form name="add_item" action="'.url("admin/modules/user/menu/new").'" method="post">';
					$table .= '<table align="center" class="admin" style="max-width:600px;"><tr class="head"><td style="width:1%;"></td><td>'.NAME.'</td><td>'.MANAGE.'</td></tr>';
					
					$query = $db->select("*", "menu", "ORDER BY id ASC");
					$ids = get_list_of_ids("menu", "ORDER BY id ASC");
					
					$table .= '<tr><td colspan="3"><div class="sep" /></td></tr>';
					
					if($db->num_rows($query) > 0)
					{
						$table .= '<tr class="row"><td colspan="3">- '.ITEMS.'</td></tr>';
						
						while($item = $db->fetch_array($query))
						{	
							$up_disabled = '';
							$down_disabled = '';
							if($item["id"] == min($ids) and $item["id"] == max($ids))
							{
								$up_disabled = ' disabled="disabled"';
								$down_disabled = ' disabled="disabled"';
							}elseif($item["id"] == min($ids)){
								$up_disabled = ' disabled="disabled"';
							}elseif($item["id"] == max($ids)){
								$down_disabled = ' disabled="disabled"';
							}
							
							$table .= '<tr class="subrow"><td style="padding:0px;text-align:center;"><button type="button" onclick="changeOrder(\''.$item["id"].'/up\');"'.$up_disabled.'><img alt="up" src="'.base_path().'/misc/up.png" /></button></td><td rowspan="2">'.$item["name"].'</td><td rowspan="2" style="text-align:center;"><a href="'.url("admin/modules/user/menu/edit").'/'.$item["id"].'">'.EDIT.'</a> - <a href="'.url("admin/modules/user/menu/delete").'/'.$item["id"].'">'.DELETE.'</a></td></tr><tr><td style="padding:0px;text-align:center;"><button type="button" onclick="changeOrder(\''.$item["id"].'/down\');"'.$down_disabled.'><img alt="down" src="'.base_path().'/misc/down.png" /></button></td></tr>';
						}
					}else{
						$table .= '<tr class="subrow"><td colspan="3">'.NO_ITEM.'</td></tr>';
					}
					
					$table .= '<tr><td colspan="3"><div class="sep" /></td></tr>';
					$table .= '<tr class="row"><td colspan="3">- '.NEW_ITEM.'</td></tr>';
					$table .= '<tr class="subrow"><td style="padding:0px;text-align:center;"><img alt="add" src="'.base_path().'/misc/add.png" /></td><td style="text-align:center;"><input name="name" type="text" maxlength="64" value="" size="40" /></td><td style="text-align:center;"><button name="submit" type="submit">'.ADD.'</button></td></tr>';
					$table .= '</table>';
					$table .= '</form>';
					
					$head = '<script type="text/javascript">function changeOrder(item){ location.href = \''.url("admin/modules/user/menu/order").'/\' + item; }</script>';
				}else{
					switch($q[4])
					{
						default;
							header("Location: ".url("admin/modules/user/menu"));
						break;
						
						case("order");
							$order = array("up", "down");
							
							if(!empty($q[5]) and !empty($q[6]) and is_numeric($q[5]) and in_array($q[6], $order))
							{
								$query = $db->select("*", "menu", "WHERE id='".$q[5]."'");
								if($item = $db->fetch_array($query))
								{
									if($q[6] == "up")
									{
										$db->update("menu", "id='".($item["id"])."' WHERE id='".($item["id"] - 1)."'");
										$db->update("menu", "id='".($item["id"] - 1)."' WHERE id='".$item["id"]."' AND name='".$item["name"]."'");
									}elseif($q[6] == "down"){
										$db->update("menu", "id='".($item["id"])."' WHERE id='".($item["id"] + 1)."'");
										$db->update("menu", "id='".($item["id"] + 1)."' WHERE id='".$item["id"]."' AND name='".$item["name"]."'");
									}
									header("Location: ".url("admin/modules/user/menu"));
								}else{
									header("Location: ".url("admin/modules/user/menu"));
								}
							}else{
								header("Location: ".url("admin/modules/user/menu"));
							}
						break;
						
						case("new");
							if(isset($_POST["name"]))
							{
								if(!is_refered_from("admin/modules/user/menu")) { exit; }
								
								$ids = get_list_of_ids("menu", "ORDER BY id ASC");
								if(count($ids) < 1) { $ids[0] = 0; }
								
								$name = @$_POST["name"];
								$name = str_filter("<,>,',\"", "&lt;,&gt;,\',&quot;", $name);
								
								$name = query_filter($name);
								$db->insert("menu", "('".(max($ids) + 1)."', '$name', '', '', '_self', '', 'all', 'everyone', '1')");
								
								header("Location: ".url("admin/modules/user/menu/edit")."/".(max($ids) + 1));
							}else{
								header("Location: ".url("admin/modules/user/menu"));
							}
						break;
						
						case("edit");
							$usergroups_list = $module["usergroup"]->get_usergroups_list();
							$languages_list = $module["language"]->get_languages_list("installed");
							
							if(!empty($q[5]) and is_numeric($q[5]))
							{
								$id = $q[5];
								
								if(isset($_POST["submit"]))
								{
									if(!is_refered_from("admin/modules/user/menu/edit/".$id)) { exit; }
									
									$query = $db->select("edit", "menu", "WHERE id='$id'");
									if($item = $db->fetch_array($query))
									{
										$fields = array("name", "title", "href", "target", "onclick");
										foreach($fields as $value)
										{
											$form[$value] = str_filter("<,>,',\"", "&lt;,&gt;,\',&quot;", @$_POST[$value]);
											$form[$value] = query_filter($form[$value]);
										}
										
										$usergroup = "";
										if(isset($_POST["everyone"]))
										{
											$usergroup = "everyone";
										}else{
											foreach($usergroups_list as $key => $value)
											{
												if(isset($_POST[$key]))
												{
													$usergroup .= $key.",";
												}
											}
											$usergroup = substr($usergroup, 0, strlen($usergroup)-1);
										}
										
										$language = "";
										if(isset($_POST["all"]))
										{
											$language = "all";
										}else{
											foreach($languages_list as $key => $value)
											{
												if(isset($_POST[$key]))
												{
													$language .= $key.",";
												}
											}
											$language = substr($language, 0, strlen($language)-1);
										}
										
										if($item["edit"] == 1)
										{
											$edit = "href='".$form["href"]."', target='".$form["target"]."', onclick='".$form["onclick"]."', ";
										}else{
											$edit = "";
										}
										
										$db->update("menu", "name='".$form["name"]."', title='".$form["title"]."', ".$edit."language='".$language."', usergroup='".$usergroup."' WHERE id='$id'");
										unset($usergroup);
										unset($language);
										unset($edit);
									}
									header("Location: ".url("admin/modules/user/menu"));
								}
								
								$query = $db->select("*", "menu", "WHERE id='$id'");
								if($item = $db->fetch_array($query))
								{
									$targets = "";
									$target = array("_blank" => NEW_WINDOW, "_parent" => PARENT_WINDOW, "_self" => SELF_WINDOW, "_top" => TOP_WINDOW);
									foreach($target as $key => $value)
									{
										if($item["target"] == $key){ $selected = ' selected="selected"'; }else{ $selected = ""; }
										$targets .= '<option value="'.$key.'"'.$selected.'>'.$value.' ('.$key.')</option>';
									}
									
									$usergroups = "";
									$usergroup_status = explode(",", $item["usergroup"]);
									foreach($usergroups_list as $key => $value)
									{
										if(in_array($key, $usergroup_status)) { $checked = ' checked="checked"'; }else{ $checked = ""; }
										$usergroups .= '<label><input name="'.$key.'" type="checkbox" value="1"'.$checked.' /> '.$value.'</label><br />';
									}
									if($item["usergroup"] == "everyone") { $checked = ' checked="checked"'; }else{ $checked = ""; }
									$usergroups .= '<label><input name="everyone" type="checkbox" value="1"'.$checked.' /> '.EVERYONE.'</label>';
									
									$languages = "";
									$language_status = explode(",", $item["language"]);
									foreach($languages_list as $value)
									{
										$language_info = $module["language"]->get_language_info($value);
										if(in_array($value, $language_status)) { $checked = ' checked="checked"'; }else{ $checked = ""; }
										$languages .= '<label><input name="'.$value.'" type="checkbox" value="1"'.$checked.' /> '.$language_info["name"].'</label><br />';
									}
									if($item["language"] == "all") { $checked = ' checked="checked"'; }else{ $checked = ""; }
									$languages .= '<label><input name="all" type="checkbox" value="1"'.$checked.' /> '.ALL.'</label>';
									
									
									if($item["edit"] == 0) { $disabled = ' disabled="disabled"'; }else{ $disabled = ""; };
									
									$table = '<form name="edit_item" action="'.url("admin/modules/user/menu/edit/".$id).'" method="post">';
									$table .= '<table>';
									$table .= '<tr><td>'.NAME.':</td><td><input name="name" type="text" maxlength="64" value="'.$item["name"].'" /></td></tr>';
									$table .= '<tr><td>'.TITLE.':</td><td><input name="title" type="text" maxlength="64" value="'.$item["title"].'" /></td></tr>';
									$table .= '<tr><td></td><td><hr size="1" /></td></tr>';
									$table .= '<tr><td>'.ADDRESS.':</td><td><input name="href" class="address" type="text" size="50" value="'.$item["href"].'"'.$disabled.' /></td></tr>';
									$table .= '<tr><td>'.TARGET.':</td><td><select name="target">'.$targets.'</select></td></tr>';
									$table .= '<tr><td>'.ONCLICK.':</td><td><input name="onclick" type="text" maxlength="64" size="50" value="'.$item["onclick"].'"'.$disabled.' /></td></tr>';
									$table .= '<tr><td colspan="2">&nbsp;</td></tr>';
									$table .= '<tr><td colspan="2"><div class="visibility"><fieldset><legend><a href="javascript:void(0);">'.VISIBILITY.'</a></legend><div class="visibility"><div class="lfloat">'.$usergroups.'</div><div class="lfloat">'.$languages.'</div></div></fieldset></div></td></tr>';
									$table .= '<tr><td colspan="2">&nbsp;</td></tr>';
									$table .= '<tr><td colspan="2"><button name="submit" type="submit">'.SAVE.'</button> <a href="'.$_SERVER["HTTP_REFERER"].'">['.BACK.']</a></td></tr>';
									$table .= '</table>';
									$table .= '</form>';
									
									$head = '<script type="text/javascript" src="'.base_path().'/misc/autocomplete.js"></script>
<link rel="stylesheet" href="'.base_path().'/misc/autocomplete.css" type="text/css" />
<script type="text/javascript">
//<![CDATA[
$(document).ready(function(){
	$(".visibility fieldset legend a").click(function(){ $(".visibility .visibility").slideToggle(); return false; });
	$.get("'.url("admin/modules/user/menu/links").'", function(data){ data = data.split(","); $("input.address").autocomplete(data, { max: 20, matchContains: true }); })
});
//]]>
</script>
';

								}else{
									header("Location: ".url("admin/modules/user/menu"));
								}
							}else{
								header("Location: ".url("admin/modules/user/menu"));
							}
						break;
						
						case("links");
							$query = $db->select("source, shortcut", "shortcuts", "ORDER BY id DESC");
							while($shortcut = $db->fetch_array($query))
							{
								echo url($shortcut["shortcut"], 1, 0).','.url($shortcut["source"], 1, 0).','.'[q='.$shortcut["shortcut"].'],';
							}
							exit;
						break;
						
						case("delete");
							if(!empty($q[5]) and is_numeric($q[5]))
							{
								$id = $q[5];
								
								$query = $db->select("id, edit", "menu", "WHERE id='$id'");
								if($item = $db->fetch_array($query))
								{
									if(isset($_POST["submit"]))
									{
										if($item["edit"] == 1)
										{
											if(!is_refered_from("admin/modules/user/menu/delete/".$id)) { exit; }
											
											$db->delete("menu", "WHERE id='$id'");
											reset_ids("menu", "ORDER BY id ASC");
										}
										header("location: ".url("admin/modules/user/menu"));
									}else{
										$table = '<form name="delete" action="" method="post"><div class="message">'.DELETE_MENU_ITEM.'<div style="text-align:center;"><button name="submit" type="submit">'.YES.'</button> <a href="'.url("admin/modules/user/menu").'">['.NO.']</a></div></div></form>';
									}
									
									if($item["edit"] == 0)
									{
										$table = '<div class="message"><ul><li>'.CANNOT_DELETE_MENU_ITEM.' <a href="'.$_SERVER["HTTP_REFERER"].'">['.BACK.']</a></li></ul></div>';
									}
								}else{
									header("Location: ".url("admin/modules/user/menu"));
								}
							}else{
								header("Location: ".url("admin/modules/user/menu"));
							}
						break;
					}
				}
			break;
			
			case("list");
				$class = array("new" => "tab", "menu" => "tab", "list" => "selected", "options" => "tab");
				
				if(!empty($q[4]))
				{
					$p = $q[4];
				}
				
				if(empty($p) or !is_numeric($p) or $p < 1)
				{
					$p = 1;
				}
				
				$users_per_page = 20;
				
				$table = '<table class="admin"><tr class="head"><td>'.USERNAME.'</td><td>'.STATUS.'</td><td>'.MEMBER_FOR.'</td><td>'.LAST_LOGIN.'</td><td>'.MANAGE.'</td></tr>';
				
				$query = $db->select("*", "users", "ORDER BY id ASC LIMIT ".(($users_per_page * $p)-$users_per_page).",".$users_per_page);
				if($db->num_rows($query) > 0)
				{
					$table .= '<tr><td colspan="5"><div class="sep" /></td></tr>';
					
					while($user = $db->fetch_array($query))
					{
						if($user["status"] == 0)
						{
							$status = BLOCKED;
						}else{
							$status = ACTIVE;
						}
						
						$member_for = $module["user"]->get_member_for($user["signedup"], 1);
						$last_login = $module["user"]->get_last_login($user["signedin"], 1);
						
						$table .= '<tr class="subrow"><td class="userico">'.$user["user"].'</td><td style="text-align:center;">'.$status.'</td><td>'.$member_for.'</td><td title="'.$user["ipaddr"].'">'.$last_login.'</td><td style="text-align:center;"><a href="'.url("admin/modules/user/edit/".$user["id"]).'">'.EDIT.'</a> - <a href="'.url("admin/modules/user/delete/".$user["id"]).'">'.DELETE.'</a></td></tr>';
					}
				}
				
				$table .= '<tr><td colspan="5"><div class="sep" /></td></tr>';
				$table .= '</table>';
				
				$num_of_users = $module["user"]->num_of_users();
				$num_of_pages = ceil($num_of_users / $users_per_page);
				if($num_of_pages > 1 and $p <= $num_of_pages)
				{
					if($p > 1)
					{
						$pages .= '<a href="'.url("admin/modules/user/list/".($p-1)).'" title="'.PREVIOUS_PAGE.'">&lt;</a> | ';
					}
					
					for($i=$p; $i<=($p + $users_per_page)-1; $i++)
					{
						if($i <= $num_of_pages)
						{
						$u1 = ''; $u2 = '';
						if($i == $p){ $u1 = '<u>'; $u2 = '</u>'; }
						$pages .= '<a href="'.url("admin/modules/user/list/".$i).'" title="'.PAGE.' '.$i.'">'.$u1.$i.$u2.'</a> | ';
						}
					}
					
					if($i <= $num_of_pages)
					{
						$pages .= '<a href="'.url("admin/modules/user/list/".$i).'" title="'.NEXT_PAGE.'">&gt;</a> | ';
					}
					
					$pages = substr($pages, 0, strlen($pages)-3);
					$table .= '<br /><div style="text-align: center;">'.PAGES.': '.$pages.'</div>';
				}		
			break;
			
			case("edit");
				include("includes/files.inc");
				
				$class = array("new" => "tab", "menu" => "tab", "list" => "selected", "options" => "tab");
				$table = "";
				
				if(!empty($q[4]) and is_numeric($q[4]))
				{
					$id = $q[4];
					
					$query = $db->select("*", "users", "WHERE id='$id'");
					if($user = $db->fetch_array($query))
					{
						if(isset($_POST["submit"]))
						{
							if(!is_refered_from("admin/modules/user/edit/".$id)) { exit; }
							
							$fields = array("user", "pass", "confirmpass", "theme", "language", "usergroup", "email", "status");
							foreach($fields as $value)
							{
								$form[$value] = @$_POST[$value];
							}
						
							$errors = array();
							if(empty($form["user"]))
							{
								array_push($errors, "MSG3");
							}else{
								if(strlen($form["user"]) < 3)
								{
									array_push($errors, "MSG4");
								}else{
									if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))([a-z0-9])*$/i" , $form["user"]))
									{
										array_push($errors, "MSG5");
									}else{
										if(strtolower($form["user"]) != strtolower($user["user"]))
										{
											if($module["user"]->user_exists($form["user"]) == true)
											{
												array_push($errors, "MSG6");
											}
										}
									}
								}
							}
							
							if(!empty($form["pass"]))
							{
								if(strlen($form["pass"]) < 6)
								{
									array_push($errors, "MSG8");
								}else{
									if(preg_match("/[(<)(>)]/", $form["pass"]))
									{
										array_push($errors, "MSG9");
									}else{
										if($form["pass"] != $form["confirmpass"])
										{
											array_push($errors, "MSG10");
										}
									}
								}
							}
							
							if(empty($form["email"]))
							{
								array_push($errors, "MSG11");
							}else{
								if(!preg_match("/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))*\@([a-z0-9])*(\.([a-z0-9])([-a-z0-9_-])([a-z0-9])+)*$/i", $form["email"]))
								{
									array_push($errors, "MSG12");
								}else{
									if($form["email"] != $user["email"])
									{
										if($module["user"]->email_exists($form["email"]) == true)
										{
											array_push($errors, "MSG13");
										}
									}
								}
							}
							
							if(isset($_FILES["picture"]))
							{
								$upload_picture = false;
								$picture = $_FILES["picture"];
								if(!empty($picture["name"]))
								{
									$options = $module["user"]->get_options();
									$extension = get_file_extension(strtolower($picture["name"]));
									$picture_exts = explode(",", $options["pictureexts"]);
									if(in_array($extension, $picture_exts))
									{
										if($picture["size"] < $options["picturemaxfilesize"])
										{
											$picture_maxsize = explode("x", $options["picturemaxsize"]);
											$picture_size = getimagesize($picture["tmp_name"]);
											if($picture_size[0] <= $picture_maxsize[0] and $picture_size[1] <= $picture_maxsize[1])
											{
												$upload_picture = true;
											}else{
												array_push($errors, "MSG16");
											}
										}else{
											array_push($errors, "MSG15");
										}
									}else{
										array_push($errors, "MSG14");
									}
								}
							}
							
							if(count($errors) < 1)
							{
								$date = getdate();
								if(empty($form["pass"]))
								{
									$form["pass"] = $user["pass"];
								}else{
									$form["pass"] = md5($form["pass"]);
								}
								if($upload_picture == true)
								{
									if(!empty($user["picture"]))
									{
										if(file_exists("uploads/".$user["picture"]))
										{
											unlink("uploads/".$user["picture"]);
										}
									}
									$file_name = md5($date[0]).".".$extension;
									move_uploaded_file($picture['tmp_name'], "./uploads/".$file_name);
								}else{
									$file_name = "";
									if(isset($_POST["removepicture"]))
									{
										if(!empty($user["picture"]))
										{
											if(file_exists("uploads/".$user["picture"]))
											{
												unlink("uploads/".$user["picture"]);
											}
										}
									}else{
										$file_name = $user["picture"];
									}
								}
								$db->update("users", "user='".$form["user"]."', pass='".$form["pass"]."', theme='".$form["theme"]."', language='".$form["language"]."', usergroup='".$form["usergroup"]."', email='".$form["email"]."', picture='".$file_name."', status='".$form["status"]."' WHERE id='$id'");
								unset($form);
								unset($picture);
								$table .= '<div class="message"><ul><li>'.MSG18.'</li></ul></div><br />';
							}else{
								$table .= '<div class="message"><ul>';
								foreach($errors as $value)
								{
									$table .= '<li>'.eval("return $value;").'</li>';
								}
								$table .= '</ul></div><br />';
							}
						}
					}
					
					$query = $db->select("*", "users", "WHERE id='$id'");
					if($user = $db->fetch_array($query))
					{	
						$themes = "";
						$themes_list = $module["theme"]->get_themes_list("installed");
						foreach($themes_list as $value)
						{
							$theme_info = $module["theme"]->get_theme_info($value);
							if($value == $user["theme"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
							$themes .= '<option value="'.$value.'"'.$selected.'>'.$theme_info["name"].'</option>';
						}
						
						$languages = "";
						$languages_list = $module["language"]->get_languages_list("installed");
						foreach($languages_list as $value)
						{
							$language_info = $module["language"]->get_language_info($value);
							if($value == $user["language"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
							$languages .= '<option value="'.$value.'"'.$selected.'>'.$language_info["name"].'</option>';
						}
						
						$usergroups = "";
						$usergroups_list = $module["usergroup"]->get_usergroups_list();
						foreach($usergroups_list as $key => $value)
						{
							if($key == $user["usergroup"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
							$usergroups .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
						}
						
						$picture = "";
						if(!empty($user["picture"]))
						{
							if(file_exists("uploads/".$user["picture"]))
							{
								$picture = '<img src="'.base_path().'/uploads/'.$user["picture"].'" alt="'.$user["user"].'" /> <label><input name="removepicture" type="checkbox" value="1" />'.REMOVE_PICTURE.'</label><br />';
							}
						}
						
						if($user["status"] == 0)
						{
							$status = '<option value="1">'.ACTIVE.'</option><option value="0" selected="selected">'.BLOCKED.'</option>';
						}else{
							$status = '<option value="1" selected="selected">'.ACTIVE.'</option><option value="0">'.BLOCKED.'</option>';
						}
						
						$table .= '<form name="edit_user" action="'.url("admin/modules/user/edit/".$id).'" method="post" enctype="multipart/form-data">';
						$table .= '<table>';
						$table .= '<tr><td>'.USERNAME.':</td><td><input name="user" type="text" value="'.$user["user"].'" /></td></tr>';
						$table .= '<tr><td>'.PASSWORD.':</td><td><input name="pass" type="password" value="" /></td></tr>';
						$table .= '<tr><td>'.CONFIRM_PASSWORD.':</td><td><input name="confirmpass" type="password" value="" /></td></tr>';
						$table .= '<tr><td colspan="2"><hr size="1" /></td></tr>';
						$table .= '<tr><td>'.THEME.':</td><td><select name="theme">'.$themes.'</select></td></tr>';
						$table .= '<tr><td>'.LANGUAGE.':</td><td><select name="language">'.$languages.'</select></td></tr>';
						$table .= '<tr><td>'.USERGROUP.':</td><td><select name="usergroup">'.$usergroups.'</select></td></tr>';
						$table .= '<tr><td colspan="2"><hr size="1" /></td></tr>';
						$table .= '<tr><td>'.EMAIL.':</td><td><input name="email" type="text" value="'.$user["email"].'" /></td></tr>';
						$table .= '<tr><td valign="bottom">'.PICTURE.':</td><td>'.$picture.'<input name="picture" type="file" value="" /></td></tr>';
						$table .= '<tr><td colspan="2"><hr size="1" /></td></tr>';
						$table .= '<tr><td>'.STATUS.':</td><td><select name="status">'.$status.'</select></td></tr>';
						$table .= '<tr><td colspan="2">&nbsp;</td></tr>';
						$table .= '<tr><td colspan="2"><button name="submit" type="submit">'.SAVE.'</button> <button type="reset">'.RESET.'</button></td></tr>';
						$table .= '</table>';
						$table .= '</form>';
					}else{
						header("Location: ".url("admin/modules/user"));
					}
				}else{
					header("Location: ".url("admin/modules/user"));
				}
			break;
			
			case("delete");
				$class = array("new" => "tab", "menu" => "", "list" => "selected", "options" => "tab");
				
				if(!empty($q[4]) and is_numeric($q[4]))
				{
					$id = $q[4];
					
					$query = $db->select("id, picture", "users", "WHERE id='$id'");
					if($id == 1)
					{
						$table = '<div class="message"><ul><li>'.CANT_DELETE.' <a href="'.$_SERVER["HTTP_REFERER"].'">['.BACK.']</a></li></ul></div>';
					}elseif($user = $db->fetch_array($query))
					{
						if(isset($_POST["submit"]))
						{
							if(!is_refered_from("admin/modules/user/delete/".$id)) { exit; }
							
							if(!empty($user["picture"]))
							{
								if(file_exists("uploads/".$user["picture"]))
								{
									unlink("uploads/".$user["picture"]);
								}
							}
							$db->delete("users", "WHERE id='$id'");
							header("location: ".url("admin/modules/user/list"));
						}else{
							$table = '<form name="delete_user" action="'.url("admin/modules/user/delete/".$id).'" method="post"><div class="message">'.DELETE_CONFIRM.'<div style="text-align:center;"><button name="submit" type="submit">'.YES.'</button> <a href="'.$_SERVER["HTTP_REFERER"].'">['.NO.']</a></div></div></form>';
						}
					}else{
						header("Location: ".url("admin/modules/user"));
					}
				}else{
					header("Location: ".url("admin/modules/user"));
				}
			break;
			
			case("options");
				$class = array("new" => "tab", "menu" => "tab", "list" => "tab", "options" => "selected");
				$message = "";
				
				if(isset($_POST["submit"]))
				{
					if(!is_refered_from("admin/modules/user/options")) { exit; }
					
					$editablefields = "";
					
					$fields = array("signup", "emailconfirm", "pictureexts", "picturemaxsize", "picturemaxfilesize", "defaultusergroup", "welcomeemailsubject", "welcomeemailmessage", "activationemailsubject", "activationemailmessage", "passwordrecoveryemailsubject", "passwordrecoveryemailmessage", "changeemailsubject", "changeemailmessage");
					
					foreach($fields as $value)
					{
						$db->update("user", "value='".str_filter("<,>,\"", "&lt;,&gt;,&quot;", query_filter($_POST[$value]))."' WHERE name='$value'");
					}
					
					$fields = array("user", "pass", "theme", "language", "usergroup", "email", "picture", "status");
					foreach($fields as $value)
					{
						if(isset($_POST[$value]))
						{
							$editablefields .= $value.",";
						}
					}
					$editablefields = substr($editablefields, 0, strlen($editablefields)-1);
					
					$db->update("user", "value='$editablefields' WHERE name='editablefields'");
					
					$message = '<div class="message"><ul><li>'.MSG18.'</li></ul></div><br />';
					
					unset($fields);
					unset($editablefields);
				}
				
				$option = array("signup" => "", "emailconfirm" => "", "pictureexts" => "", "picturemaxsize" => "", "picturemaxfilesize" => "", "defaultusergroup" => "", "welcomeemailsubject" => "", "welcomeemailmessage" => "", "activationemailsubject" => "", "activationemailmessage" => "", "passwordrecoveryemailsubject" => "", "passwordrecoveryemailmessage" => "", "changeemailsubject" => "", "changeemailmessage" => "");
				$options = $module["user"]->get_options();
				
				$signup = array(0 => DISABLE, 1 => ENABLE);
				foreach($signup as $key => $value)
				{
					if($key == $options["signup"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
					$option["signup"] .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
				}
				
				$emailconfirm = array(0 => DISABLE, 1 => ENABLE);
				foreach($emailconfirm as $key => $value)
				{
					if($key == $options["emailconfirm"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
					$option["emailconfirm"] .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
				}
				
				$usergroups_list = $module["usergroup"]->get_usergroups_list();
				foreach($usergroups_list as $key => $value)
				{
					if($key == $options["defaultusergroup"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
					$option["defaultusergroup"] .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
				}
				
				$option["pictureexts"] = $options["pictureexts"];
				$option["picturemaxsize"] = $options["picturemaxsize"];
				$option["picturemaxfilesize"] = $options["picturemaxfilesize"];
				
				$allfields = array("user", "pass", "theme", "language", "usergroup", "email", "picture", "status");
				$editablefields = explode(",", $options["editablefields"]);
				foreach($allfields as $value)
				{
					if(in_array($value, $editablefields))
					{
						$option[$value] = ' checked="checked"';
					}else{
						$option[$value] = "";
					}
				}
				
				$opts = array("welcomeemailsubject", "welcomeemailmessage", "activationemailsubject", "activationemailmessage", "passwordrecoveryemailsubject", "passwordrecoveryemailmessage", "changeemailsubject", "changeemailmessage", );
				foreach($opts as $value)
				{
					$option[$value] = $options[$value];
				}
				
				$table = $modules->load_template("modules/user/temp/options.tpl");
				$table = eval("return '".$table."';");
				
				$head = '<script type="text/javascript">
$(document).ready(function(){
		$(".activationemail .activationemail").slideToggle();
		$(".passwordrecoveryemail .passwordrecoveryemail").slideToggle();
		$(".changeemail .changeemail").slideToggle();
		
		$(".welcomeemail fieldset legend a").click(function(){
			$(".welcomeemail .welcomeemail").slideDown();
			$(".activationemail .activationemail, .passwordrecoveryemail .passwordrecoveryemail, .changeemail .changeemail").slideUp();
			return false;
		});
		$(".activationemail fieldset legend a").click(function(){
			$(".activationemail .activationemail").slideDown();
			$(".welcomeemail .welcomeemail, .passwordrecoveryemail .passwordrecoveryemail, .changeemail .changeemail").slideUp();
			return false;
		});
		$(".passwordrecoveryemail fieldset legend a").click(function(){
			$(".passwordrecoveryemail .passwordrecoveryemail").slideDown();
			$(".welcomeemail .welcomeemail, .activationemail .activationemail, .changeemail .changeemail").slideUp();
			return false;
		});
		$(".changeemail fieldset legend a").click(function(){
			$(".changeemail .changeemail").slideDown();
			$(".welcomeemail .welcomeemail, .activationemail .activationemail, .passwordrecoveryemail .passwordrecoveryemail").slideUp();
			return false;
		});
});
</script>'."\n";
			break;
		}
	}
	
	$result["head"] = $modules->get_style("user")."\n".$head;
	$result["content"] = $modules->load_template("modules/user/temp/admin.tpl");
	$result["content"] = eval("return '".$result["content"]."';");
	
	return $result;
}

?>