<?php

class Theme
{
	function get_themes_list($themes = "all")
	{
		global $db;
		
		$list = array();
		
		switch($themes)
		{
			default;
				$dir = opendir("./themes");
				while($file = readdir($dir))
				{
					if($file != "." and $file != ".." and $file != "index.html")
					{
						array_push($list, $file);
					}
				}
				closedir($dir);
			break;
			
			case("installed");
				$query = $db->select("*", "themes", "ORDER BY name ASC");
				while($theme = $db->fetch_array($query))
				{
					$list[$theme["id"]] = $theme["name"];
				}
			break;
			
			case("uninstalled");
				$all = $this->get_themes_list();
				$installed = $this->get_themes_list("installed");
				foreach($all as $value)
				{
					if(!in_array($value, $installed))
					{
						array_push($list, $value);
					}
				}
			break;
		}
		return $list;
	}
	
	function get_theme_info($theme)
	{
		$file = "themes/$theme/$theme.info";
		$open = fopen($file, "r");
		$contents = fread($open, filesize($file));
		$line = explode("\n", $contents);
		$info = array();
		for($i=2; $i<count($line); $i++)
		{
			$item = explode(" = ", $line[$i]);
			$info[$item[0]] = trim($item[1]);
		}
		fclose($open);
		return $info;
	}
	
	function load_page_elements()
	{
		global $db, $module;
		
		$theme = array("head" => "", "header" => "", "left" => "", "content" => "", "right" => "", "footer" => "");
		
		$theme["head"] = $this->include_head();
		
		if($module["user"]->is_authorized())
		{
			$usergroup = $module["user"]->get_user_info("usergroup");
			$language = $module["user"]->get_user_info("language");
		}else{
			$usergroup = NULL;
			$language = NULL;
		}
		
		$query = $db->select("*", "blocks", "ORDER BY id ASC");
		while($block = $db->fetch_array($query))
		{
			if($block["language"] == "all" or in_array($language, explode(",", $block["language"])))
			{
				if(($block["usergroup"] == "everyone" or in_array($usergroup, explode(",", $block["usergroup"]))))
				{
					$theme[$block["area"]] .= $this->include_block($block);
				}
			}
		}
		return $theme;
	}
	
	function include_block($block)
	{
		global $module;
		
		$title = $module["block"]->eval_it($block["title"]);
		$content = $module["block"]->eval_it($block["content"]);
		
		if($block["edit"] == 1)
		{
			$title = strip_tags($title);
			$content = strip_tags($content, "<h1><h2><h3><h4><h5><h6><p><br><hr><pre><em><strong><code><big><small><strike><tt><b><i><u><a><img><ul><ol><dl><dt><dd><li><table><tr><td><thead><tbody><center><embed><font><menu><span>");
		}
		
		if(empty($title))
		{
			return $content;
		}else{
			if(!empty($content))
			{
				global $settings;
				$title = stripslashes($title);
				$content = stripslashes($content);
				$title = str_replace('"', '\"', $title);
				$content = str_replace('"', '\"', $content);
				return get_include_contents("themes/".$settings["theme"]."/block.php", '$block = array("title" => "'.$title.'", "content" => "'.$content.'");');
			}
		}
	}
	
	function include_head()
	{
		global $db, $modules;
		
		$head = "";
		
		$query = $db->select("*", "head");
		while($module = $db->fetch_array($query))
		{
			if($modules->is_compatible($module["module"]))
			{
				$head .= eval($module["eval"])."\n";
			}
		}
		return $head;
	}
	
	function print_theme()
	{
		global $settings;
		
		return get_include_contents("themes/".$settings["theme"]."/page.php", '$settings = $GLOBALS["settings"]; $theme = $GLOBALS["theme"]; $lang = $GLOBALS["lang"]; $page = $GLOBALS["page"];');
	}
	
	function is_compatible($theme)
	{
		global $settings;
		
		$version = get_file_version("themes/$theme/$theme.info");
		$x_pos = strpos(strtolower($version), "x");
		if(!empty($x_pos))
		{
			$version = substr($version, 0, $x_pos);
			$settings_version = substr($settings["version"], 0, $x_pos);
		}else{
			$settings_version = '';
		}
		
		if($version == $settings_version)
		{
			return true;
		}else{
			return false;
		}
	}
}

?>