<?php

function install_page($install)
{
	global $db, $module, $modules;
	
	$modules->include_language("theme");
	
	$errors = array();
	if(!in_array($install, $module["theme"]->get_themes_list()))
	{
		array_push($errors, "MSG1");
	}else{
		if(in_array($install, $module["theme"]->get_themes_list("installed")))
		{
			array_push($errors, "MSG2");
		}else{
			if(!file_exists("themes/$install/$install.info"))
			{
				array_push($errors, "MSG3");
			}else{
				if(!$module["theme"]->is_compatible($install))
				{
					array_push($errors, "MSG4");
				}
			}
		}
	}
	
	if(count($errors) < 1)
	{
		$info = $module["theme"]->get_theme_info($install);
		
		$ids = get_list_of_ids("themes");
		$db->insert("themes", "('".(max($ids) + 1)."', '$install')");
		
		$table = '<div class="message"><ul><li>'.str_replace("{THEME}", $info["name"], MSG6).' <a href="'.url("admin/modules/theme").'">['.BACK.']</a></li></ul></div>';
	}else{
		$table = '<div class="message"><ul>';
		foreach($errors as $value)
		{
			$table .= '<li>'.eval("return $value;").' <a href="'.url("admin/modules/theme").'">['.BACK.']</a></li>';
		}
		$table .= '</ul></div><br />';
	}
	
	$result["content"] = $table;
	return $result;
}


function uninstall_confirm($theme)
{
	global $module, $modules;
	
	$modules->include_language("theme");
	
	$themes_list = $module["theme"]->get_themes_list("installed");
	if(in_array($theme, $themes_list))
	{
		$theme_info = $module["theme"]->get_theme_info($theme);
		
		$table = '<form name="uninstall_confirm" action="" method="post"><div class="message">'.str_replace("{THEME}", $theme_info["name"], UNINSTALL_CONFIRM).'<div style="text-align:center;"><button name="submit" type="submit">'.YES.'</button> <a href="'.url("admin/modules/theme").'">['.NO.']</a></div></div></form>';
	
	}else{
		$table = '<div class="message"><ul><li>'.str_replace("{THEME}", $theme, MSG8).' <a href="'.url("admin/modules/theme").'">['.BACK.']</a></li></ul></div>';
	}
	$result["content"] = $table;
	return $result;
}

function uninstall_page($uninstall)
{
	global $db, $module, $modules, $settings;
	
	$modules->include_language("theme");
	
	$errors = array();
	if(!in_array($uninstall, $module["theme"]->get_themes_list("installed")))
	{
		array_push($errors, "MSG1");
	}else{
		if(!file_exists("themes/$uninstall/$uninstall.info"))
		{
			array_push($errors, "MSG3");
		}else{
			if($uninstall == $settings["theme"])
			{
				array_push($errors, "MSG5");
			}
		}
	}
	
	if(count($errors) < 1)
	{
		$theme_info = $module["theme"]->get_theme_info($uninstall);
		
		$db->delete("themes", "WHERE name='$uninstall'");
		
		$query = $db->select("id", "users", "WHERE theme='".$uninstall."'");
		while($user = $db->fetch_array($query))
		{
			$db->update("users", "theme='".$settings["theme"]."' WHERE id='".$user["id"]."'");
		}
		
		$table = '<div class="message"><ul><li>'.str_replace("{THEME}", $theme_info["name"], MSG7).' <a href="'.url("admin/modules/theme").'">['.BACK.']</a></li></ul></div>';
	}else{
		$table = '<div class="message"><ul>';
		foreach($errors as $value)
		{
			$table .= '<li>'.eval("return $value;").' <a href="'.url("admin/modules/theme").'">['.BACK.']</a></li>';
		}
		$table .= '</ul></div><br />';
	}
	
	$result["content"] = $table;
	return $result;
}

?>