<?php

function administration()
{
	global $db, $module, $modules;
	
	$q = get_query();
	$modules->include_language("theme");
	
	if(empty($q[3]))
	{
		$table = '<table class="admin"><tr class="head"><td>'.SCREENSHOT.'</td><td>'.NAME.'</td><td>'.VERSION.'</td><td>'.DESCRIPTION.'</td><td>'.MANAGE.'</td></tr>';
		$table .= '<tr><td colspan="5"><div class="sep" /></td></tr>';
		$table .= '<tr class="row"><td colspan="5">- '.INSTALLED.'</td></tr>';
		
		$installed_themes = $module["theme"]->get_themes_list("installed");
		foreach($installed_themes as $value)
		{
			$theme_info = $module["theme"]->get_theme_info($value);
			
			if(empty($theme_info["screenshot"]) and file_exists("themes/".$theme["name"]."/".$theme_info["screenshot"]))
			{
				$screenshot = '<img alt="'.NO_PREVIEW.'" src="'.base_path().'/misc/nopreview.png" />';
			}else{
				$screenshot = '<img alt="'.$theme_info["name"].'" src="'.base_path().'/themes/'.$value.'/'.$theme_info["screenshot"].'" />';
			}
			
			$table .= '<tr class="subrow"><td style="text-align:center;width:10%;">'.$screenshot.'</td><td>'.$theme_info["name"].'</td><td style="text-align:center;">'.$theme_info["version"].'</td><td class="desc">'.$theme_info["description"].'</td><td style="text-align:center;"><a href="'.url("admin/modules/theme/uninstall/".$value).'">'.UNINSTALL.'</a></td></tr>';
		}
		
		$table .= '<tr><td colspan="5"><div class="sep" /></td></tr>';
		$table .= '<tr class="row"><td colspan="5">- '.UNINSTALLED.'</td></tr>';
		
		$uninstalled = "";
		$uninstalled_themes = $module["theme"]->get_themes_list("uninstalled");
		foreach($uninstalled_themes as $value)
		{
			$theme_info = $module["theme"]->get_theme_info($value);
			
			if(!$module["theme"]->is_compatible($value))
			{
				$tr = "unsup";
			}else{
				$tr = "subrow";
			}
			
			if(empty($theme_info["screenshot"]) and file_exists("themes/".$value."/".$theme_info["screenshot"]))
			{
				$screenshot = '<img alt="'.NO_PREVIEW.'" src="'.base_path().'/misc/nopreview.png" />';
			}else{
				$screenshot = '<img alt="'.$theme_info["name"].'" src="'.base_path().'/themes/'.$value.'/'.$theme_info["screenshot"].'" />';
			}
			
			$uninstalled .= '<tr class="'.$tr.'"><td style="text-align:center;width:10%;">'.$screenshot.'</td><td>'.$theme_info["name"].'</td><td style="text-align:center;">'.$theme_info["version"].'</td><td class="desc">'.$theme_info["description"].'</td><td style="text-align:center;"><a href="'.url("admin/modules/theme/install/".$value).'">'.INSTALL.'</a></td></tr>';
		}
		
		if(!empty($uninstalled))
		{
			$table .= $uninstalled;
		}else{
			$table .= '<tr class="subrow"><td colspan="5">'.NO_UNINSTALLED_THEME.'</td></tr>';
		}
		
		$table .= '</table>';
		$result["content"] = $table;
	}else{
		switch($q[3])
		{
			default;
				header("Location: ".url("admin/modules/theme"));
			break;
			
			case("install");
				if(!empty($q[4]))
				{
					include("modules/theme/install.php");
					$result = install_page($q[4]);
				}else{
					header("Location: ".url("admin/modules/theme"));
				}
			break;
			
			case("uninstall");
				if(!empty($q[4]))
				{
					include("modules/theme/install.php");
					if(isset($_POST["submit"]))
					{
						$result = uninstall_page($q[4]);
					}else{
						$result = uninstall_confirm($q[4]);
					}
				}else{
					header("Location: ".url("admin/modules/theme"));
				}
			break;
		}
	}
	return $result;
}

?>