<?php

class Language
{
	function language_block()
	{
		global $db, $page, $settings;
		
		$languages = "";
		$query = $db->select("`key`, `name`", "languages", "ORDER BY id ASC");
		while($language = $db->fetch_array($query))
		{
			if($language["key"] == $page["language"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
			$languages .= '<option value="'.$language["key"].'"'.$selected.'>'.$language["name"].'</option>';
		}
		
		$q = implode("/", get_query());
		if(!empty($q) and !empty($page["q"]) and strlen($page["q"]) > 2)
		{
			$q = '/'.str_filter("<,>,\"", "&lt;,&gt;,&quot;", $q);
		}else{
			$q = '';
		}
		
		$languages = '<div style="text-align:center;"><select name="language" onchange="location.href=\''.url("' + this.value + '", 1, 0).''.$q.'\';">'.$languages.'</select></div>';
		return $languages;
	}
	
	function get_language_info($key)
	{
		$file = "languages/$key/$key.info";
		$open = fopen($file, "r");
		$contents = fread($open, filesize($file));
		$line = explode("\n", $contents);
		$info = array();
		for($i=2; $i<count($line); $i++)
		{
			$item = explode(" = ", $line[$i]);
			$info[$item[0]] = $item[1];
		}
		fclose($open);
		return $info;
	}
	
	function language_block_title()
	{
		global $modules;
		
		$modules->include_language("language");
		return LANGUAGE;
	}
	
	function is_compatible($key)
	{
		global $settings;
		
		$version = get_file_version("languages/$key/$key.info");
		$x_pos = strpos(strtolower($version), "x");
		if(!empty($x_pos))
		{
			$version = substr($version, 0, $x_pos);
			$settings_version = substr($settings["version"], 0, $x_pos);
		}
		
		if($version == $settings_version)
		{
			return true;
		}else{
			return false;
		}
	}
	
	function install_language($key, $name)
	{
		global $db;
		
		$ids = get_list_of_ids("languages");
		$add = $db->insert("languages", "('".(max($ids) + 1)."', '$key', '$name')");
	}
	
	function uninstall_language($key)
	{
		global $db;
		
		$db->delete("languages", "WHERE `key`='$key'");
		reset_ids("languages", "ORDER BY id ASC");
	}
	
	function get_languages_list($languages = "all")
	{
		global $db;
		
		$list = array();
		
		switch($languages)
		{
			default;
				$dir = opendir("./languages");
				while($language = readdir($dir))
				{
					if($language != "." and $language != "..")
					{
						array_push($list, $language);
					}
				}
				closedir($dir);
			break;
			
			case("installed");
				$query = $db->select("`key`", "languages", "ORDER BY `key` ASC");
				while($language = $db->fetch_array($query))
				{
					array_push($list, $language["key"]);
				}
			break;
			
			case("uninstalled");
				$all = $this->get_languages_list();
				$installed = $this->get_languages_list("installed");
				foreach($all as $value)
				{
					if(!in_array($value, $installed))
					{
						array_push($list, $value);
					}
				}
			break;
		}
		
		return $list;
	}
	
	function get_language()
	{
		$language = "";
		
		if(isset($_GET["q"]))
		{
			$q = $_GET["q"];
			$q = explode("/", $q);
			$list = $this->get_languages_list("installed");
			
			if(in_array($q[0], $list))
			{
				$language = $q[0];
			}
		}
		
		return $language;
	}
}

?>