<?php

class Content
{
	function get_content()
	{
		global $page;
		
		$q = get_query();
		$implode = implode("/", $q);
		$page["q"] = @$_GET["q"];
		
		if(!empty($implode))
		{
			global $modules, $page;
			
			if($modules->is_installed($q[0]) and $modules->is_compatible($q[0]))
			{
				$data = $this->module_to_content($q[0]);
				
				if(!empty($data["head"]))
				{
					$page["head"] = $data["head"];
				}
				
				if(!empty($data["title"]))
				{
					$page["title"] = $data["title"];
				}
				return $data["content"];
			}else{
				$options = $this->get_options();
				if($options["shortcut"] == "1")
				{
					if($this->is_shortcut($_GET["q"]))
					{
						if($options["shortcuttype"] == "include")
						{
							$q = $this->get_shortcut_source($_GET["q"]);
							$q = explode("/", $q);
							if($modules->is_installed($q[0]) and $modules->is_compatible($q[0]))
							{
								$data = $this->module_to_content($q[0], $q);
								if(!empty($data["title"]))
								{
									$page["title"] = $data["title"];
								}
								if(!empty($data["head"]))
								{
									$page["head"] = $data["head"];
								}
								$result = $data["content"];
								return $result;
							}
						}elseif($options["shortcuttype"] == "redirect"){
							header("Location: ".url($this->get_shortcut_source($_GET["q"])));
						}
					}else{
						return $this->page_not_found();
					}
				}else{
					return $this->page_not_found();
				}
			}
		}else{
			return $this->default_content();
		}
	}
	
	function module_to_content($module, $source = "")
	{
		global $db;
		
		$module = query_filter($module);
		
		$query = $db->select("eval", "contents", "WHERE module='$module'");
		if($content = $db->fetch_array($query))
		{
			if(!empty($source))
			{
				$q = $source;
			}else{
				$q = get_query();
			}
			return eval($content["eval"].";");
		}
	}
	
	function default_content()
	{
		global $db, $page, $modules;
		
		$options = $this->get_options();
		$default = $options["default"];
		
		if($default == "module")
		{
			$mdl = $options["module"];
			$_GET["q"] = $mdl;
			if($modules->is_installed($mdl) and $modules->is_compatible($mdl))
			{
				$data = $this->module_to_content($mdl);
				if(!empty($data["head"]))
				{
					$page["head"] = $data["head"];
				}
				$result = $data["content"];
			}
		}elseif($default == "query"){
			$que = $options["query"];
			$_GET["q"] = $que;
			$que = explode("/", $que);
			if($modules->is_installed($que[0]) and $modules->is_compatible($que[0]))
			{
				$data = $this->module_to_content($que[0]);
				if(!empty($data["head"]))
				{
					$page["head"] = $data["head"];
				}
				$result = $data["content"];
			}else{
				$result = $this->page_not_found();
			}
		}elseif($default == "code"){
			$result = $options["code"];
		}
		
		return $result;
	}
	
	function page_not_found()
	{
		$options = $this->get_options();
		return $options["pagenotfounderror"];
	}
	
	function is_shortcut($shortcut)
	{
		global $db;
		
		$shortcut = query_filter($shortcut);
		$query = $db->select("shortcut", "shortcuts", "WHERE shortcut='$shortcut'");
		if($shortcut = $db->fetch_array($query))
		{
			return true;
		}else{
			return false;
		}
	}
	
	function get_shortcut_source($shortcut)
	{
		global $db;
		
		$shortcut = query_filter($shortcut);
		$query = $db->select("source", "shortcuts", "WHERE shortcut='$shortcut'");
		if($source = $db->fetch_array($query))
		{
			return $source["source"];
		}
	}
	
	function shortcut_exists($shortcut)
	{
		global $db;
		
		$shortcut = query_filter($shortcut);
		$query = $db->select("shortcut", "shortcuts", "WHERE shortcut='$shortcut'");
		if($exists = $db->fetch_array($query))
		{
			return true;
		}else{
			return false;
		}
	}
	
	function is_shortcut_same_as_content($shortcut)
	{
		global $db;
		
		$shortcut = query_filter($shortcut);
		$query = $db->select("module", "contents", "WHERE module='$shortcut'");
		if($exists = $db->fetch_array($query))
		{
			return true;
		}else{
			return false;
		}
	}
	
	function shortcut_check($shortcut)
	{
		global $db, $modules;
		
		if(preg_match("/[(#)(%)(&)(%)(+)(|)(>)(<)(:)(\")(')(*)(\\\\)]/", $shortcut))
		{
			return false;
		}else{
			/*
			if(preg_match("/[(\/)]/", $shortcut))
			{
				$shortcut = explode("/", $shortcut);
				if($modules->is_installed($shortcut[0]))
				{
					return false;
				}else{
					return true;
				}
			}else{
				return true;
			}
			*/
			if(preg_match("/[(\/)]/", $shortcut))
			{
				$shortcut = explode("/", $shortcut);
				$shortcut = $shortcut[0];
			}
			if($modules->is_installed($shortcut))
				{
					return false;
				}else{
					return true;
				}
		}
	}
	
	function get_options()
	{
		global $db;
		
		$query = $db->select("*", "content");
		while($option = $db->fetch_array($query))
		{
			$options[$option["name"]] = $option["value"];
		}
		return $options;
	}
}

?>