<?php

function settings_page()
{
	global $db, $module, $modules;
	
	include("includes/files.inc");
	$modules->include_language("admin");
	
	if(isset($_POST["submit"]))
	{
		if(!is_refered_from("admin/settings")) { exit; }
		
		$items = array("title", "theme", "language", "site", "email", "header", "footer", "titleseperator", "urltype", "byindexphp");
		foreach($items as $value)
		{
			$item[$value] = str_filter("<,>,\"", "&lt;,&gt;,&quot;", @$_POST[$value]);
			if($value == "footer")
			{
				$item[$value] = nl2br($item[$value]);
			}
			$item[$value] = query_filter($item[$value]);
			$db->update("settings", "value='".$item[$value]."' WHERE name='$value'");
		}
		if($item["urltype"] == "full")
		{
			edit_file("./.htaccess", "");
			if(empty($item["byindexphp"]))
			{
				$byindexphp = "";
			}else{
				$byindexphp = "index.php";
			}
			header("Location: ".base_path()."/$byindexphp?q=admin/settings");
		}elseif($item["urltype"] == "shortened"){
			edit_file("./.htaccess", "<IfModule mod_rewrite.c>\n\tRewriteEngine On\n\tRewriteCond %{REQUEST_FILENAME} !-d\n\tRewriteCond %{REQUEST_FILENAME} !-f\n\tRewriteRule ^(.*)$ index.php?q=$1 [L,QSA]\n</IfModule>");
			header("Location: ".base_path()."/admin/settings");
		}
	}
	
	$settings = get_settings();
	$item = $settings;
	
	$item["theme"] = '<select name="theme">';
	$themes = $module["theme"]->get_themes_list("installed");
	foreach($themes as $value)
	{
		$theme_info = $module["theme"]->get_theme_info($value);
		if($value == $settings["theme"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
		$item["theme"] .= '<option value="'.$value.'"'.$selected.'>'.$theme_info["name"].'</option>';
	}
	$item["theme"] .= '</select>';
	
	$item["language"] = '<select name="language">';
	$languages = $module["language"]->get_languages_list("installed");
	foreach($languages as $value)
	{
		$language_info = $module["language"]->get_language_info($value);
		if($value == $settings["language"]) { $selected = ' selected="selected"'; }else{ $selected = ""; }
		$item["language"] .= '<option value="'.$value.'"'.$selected.'>'.$language_info["name"].'</option>';
	}
	$item["language"] .= '</select>';
	
	$urltype_full = "";
	$urltype_byindexphp = "";
	if($settings["urltype"] == "full")
	{
		$urltype_full = 'checked="checked" ';
		if($settings["byindexphp"] == "1")
		{
			$urltype_byindexphp = 'checked="checked" ';
		}
	}
	
	if($settings["urltype"] == "shortened")
	{
		$urltype_shortened = 'checked="checked" ';
	}else{
		$urltype_shortened = "";
	}
	
	$item["footer"] = str_filter("<br />", "", $item["footer"]);
	
	$result = array("title" => SETTINGS, "head" => $modules->get_style("admin"), "content" => eval("return '".($modules->load_template("modules/admin/settings.tpl"))."';"));
	return $result;
}

?>