<?php

function modules_pages()
{
	global $db, $modules;
	
	$modules->include_language("admin");
	
	$table = '<table class="admin"><tr class="head"><td>'.NAME.'</td><td>'.VERSION.'</td><td>'.DESCRIPTION.'</td><td>'.MANAGE.'</td></tr>';
	$table .= '<tr><td colspan="4"><div class="sep" /></td></tr>';
	$table .= '<tr class="row"><td colspan="4">- '.INSTALLED.'{FIND_UPDATES}</td></tr>';
	
	$query = $db->select("name, config", "modules", "WHERE core='0' ORDER BY name ASC");
	if($db->num_rows($query) > 0)
	{
		while($module = $db->fetch_array($query))
		{
			$module_info = $modules->get_module_info($module["name"]);
			
			if($modules->is_compatible($module["name"]))
			{
				$tr = "subrow";
			}else{
				$tr = "unsup";
			}
			
			if(empty($module["config"]))
			{
				$config = "";
			}else{
				$config = '<a href="'.url("admin/modules/".$module["name"]).'">'.CONFIGURATION.'</a> - ';
			}
			
			$table .= '<tr class="'.$tr.'"><td class="moduleico">'.$module_info["name"].'</td><td style="text-align:center;">'.$module_info["version"].'</td><td class="desc">'.$module_info["description"].'</td><td style="text-align:center;">'.$config.'<a href="'.url("admin/modules/uninstall/".$module["name"]).'">'.UNINSTALL.'</a></td></tr>';
		}
		$table = str_replace("{FIND_UPDATES}", ' <a href="'.url("admin/updates").'" title="">('.FIND_UPDATES.')</a>', $table);
	}else{
		$table .= '<tr class="subrow"><td colspan="4">'.NO_INSTALLED_MODULE.'</td></tr>';
		$table = str_replace("{FIND_UPDATES}", "", $table);
	}
	
	$table .= '<tr><td colspan="4"><div class="sep" /></td></tr>';
	$table .= '<tr class="row"><td colspan="4">- '.UNINSTALLED.'</td></tr>';
	
	$uninstalled = "";
	$uninstalled_modules = $modules->get_modules_list();
	$installed = $modules->get_installed_modules();
	foreach($uninstalled_modules as $key => $value)
	{
		if(!in_array($value, $installed["module"]))
		{
			$module_info = $modules->get_module_info($value);
			
			if($modules->is_compatible($value))
			{
				$tr = "subrow";
			}else{
				$tr = "unsup";
			}
			
			$uninstalled .= '<tr class="'.$tr.'"><td class="moduleico">'.$module_info["name"].'</td><td style="text-align:center;">'.$module_info["version"].'</td><td class="desc">'.$module_info["description"].'</td><td style="text-align:center;"><a href="'.url("admin/modules/install/".$value).'">'.INSTALL.'</a></td></tr>';
		}
	}
	
	if(empty($uninstalled))
	{
		$table .= '<tr class="subrow"><td colspan="4">'.NO_UNINSTALLED_MODULE.'</td></tr>';
	}else{
		$table .= $uninstalled;
	}
	
	$table .= '<tr><td colspan="4"><div class="sep" /></td></tr>';
	$table .= '<tr class="row"><td colspan="4">- '.CORE.'</td></tr>';
	
	$query = $db->select("name", "modules", "WHERE core='1' ORDER BY name ASC");
	while($module = $db->fetch_array($query))
	{
		$module_info = $modules->get_module_info($module["name"]);
		
		$table .= '<tr class="subrow"><td class="moduleico">'.$module_info["name"].'</td><td style="text-align:center;">'.$module_info["version"].'</td><td class="desc">'.$module_info["description"].'</td><td style="text-align:center;"><a href="'.url("admin/modules/".$module["name"]).'">'.CONFIGURATION.'</a></td></tr>';
	}
	
	$table .= '</table>';
	
	$result["title"] = MODULES;
	$result["head"] = $modules->get_style("admin");
	$result["content"] = $modules->load_template("modules/admin/modules.tpl");
	$result["content"] = eval("return '".$result["content"]."';");
	return $result;
}

function module()
{
	global $db, $modules;
	
	$q = get_query();
	$module = $q[2];
	
	if($modules->is_compatible($module))
	{
		$info = $modules->get_module_info($module);
		
		if(file_exists("modules/$module/icon"))
		{
			$icon = base_path()."/modules/$module/icon";
		}else{
			$icon = base_path()."/misc/module.png";
		}
		
		$module = query_filter($module);
		$query = $db->select("config", "modules", "WHERE name='$module'");
		if($module = $db->fetch_array($query))
		{
			$get = eval($module["config"].";");
		}
		
		if(empty($get["title"]))
		{
			$title = $info["name"];
		}else{
			$title = $get["title"];
		}
		
		$head = $modules->get_style("admin");;
		if(!empty($get["head"]))
		{
			$head .= "\n".$get["head"];
		}
		
		$result = array("title" => $title, "head" => $head, "content" => module_temp($info, $icon).$get["content"]);
	}else{
		$modules->include_language("admin");
		$result = array("title" => MESSAGE, "content" => '<div class="message"><ul><li>'.MSG7.' <a href="'.$_SERVER["HTTP_REFERER"].'" title="'.BACK.'">['.BACK.']</a></li></ul></div>');
	}
	return $result;
}

function module_temp($module, $icon)
{
	global $modules;
	
	$modules->include_language("admin");
	$result = $modules->load_template("modules/admin/module.tpl");
	$result = eval("return '".$result."';");
	return $result;
}

?>