<?php

function install_page()
{
	global $modules;
	
	$q = get_query();
	if(empty($q[3]))
	{
		$module_name = "";
	}else{
		$module_name = $q[3];
	}
	$modules->include_language("admin");
	
	$errors = array();
	if(!in_array($module_name, $modules->get_modules_list()))
	{
		array_push($errors, "MSG4");
	}else{
		$installed = $modules->get_installed_modules();
		if(in_array($module_name, $installed["module"]))
		{
			array_push($errors, "MSG5");
		}else{
			if(!file_exists("modules/$module_name/$module_name.info"))
			{
				array_push($errors, "MSG6");
			}else{
				if(!$modules->is_compatible($module_name))
				{
					array_push($errors, "MSG7");
				}else{
					if(!$modules->are_req_mods_installed($module_name))
					{
						array_push($errors, "MSG8");
					}else{
						if(!file_exists("modules/$module_name/install.php"))
						{
							array_push($errors, "MSG9");
						}
					}
				}
			}
		}
	}
	
	if(count($errors) < 1)
	{
		include("modules/$module_name/install.php");
		$module_info = $modules->get_module_info($module_name);
		$do_install = install();
		if(empty($do_install))
		{
			$table = '<div class="message"><ul><li>'.str_replace("{MODULE}", $module_info["name"], MSG10).' <a href="'.url("admin/modules").'">['.BACK.']</a></li></ul></div>';
		}else{
			$module = $module_info;
			if(file_exists("modules/$module_name/icon"))
			{
				$icon = base_path()."/modules/$module_name/icon";
			}else{
				$icon = base_path()."/misc/module.png";
			}
			
			$table = $modules->load_template("modules/admin/module.tpl");
			$table = eval("return '".$table."';").$do_install;
		}
	}else{
		$table = '<div class="message"><ul>';
		
		$addition = "";
		foreach($errors as $value)
		{
			if($value == "MSG8")
			{
				$req_mods = $modules->get_required_modules($module_name);
				foreach($req_mods["module"] as $key => $add)
				{
					$addition .= "<b>".$add." ".$req_mods["version"][$key]."</b>, "; 
				}
				$addition = substr($addition, 0, strlen($addition)-2);
			}
			$table .= '<li>'.eval("return $value;").' '.$addition.' <a href="'.url("admin/modules").'">['.BACK.']</a></li>';
		}
		$table .= '</ul></div><br />';
	}
	
	$result = array("title" => MODULE_INSTALLATION, "head" => $modules->get_style("admin"), "content" => $table);
	return $result;
}

function uninstall_confirm()
{	
	global $modules;
	
	$q = get_query();
	if(empty($q[3]))
	{
		$module_name = "";
	}else{
		$module_name = $q[3];
	}
	$modules->include_language("admin");
	
	if(in_array($module_name, $modules->get_modules_list()))
	{
		$module = $modules->get_module_info($module_name);
		if(file_exists("modules/".$module["module"]."/icon"))
		{
			$icon = base_path()."/modules/".$module["module"]."/icon";
		}else{
			$icon = base_path()."/modules/admin/images/module.png";
		}
		
		$table = $modules->load_template("modules/admin/module.tpl");
		$table = eval("return '".$table."';").'<form name="uninstall_confirm" action="'.url("admin/modules/uninstall/".$module_name).'" method="post"><div class="message">'.str_replace("{MODULE}", $module["name"], UNINSTALL_CONFIRM).'<div style="text-align:center;"><button name="submit" type="submit">'.YES.'</button> <a href="'.url("admin/modules").'">['.NO.']</a></div></div></form>';
		
		$result = array("title" => MODULE_UNINSTALLATION, "head" => $modules->get_style("admin"), "content" => $table);
	}else{
		$result = array("title" => MESSAGE, "content" => '<div class="message"><ul><li>'.MSG4.' <a href="'.url("admin/modules").'">['.BACK.']</a></li></ul></div>');
	}
	return $result;
}

function uninstall_page()
{
	global $modules;
	
	$q = get_query();
	$module_name = $q[3];
	$modules->include_language("admin");
	
	$errors = array();
	$installed = $modules->get_installed_modules();
	if(!in_array($module_name, $installed["module"]))
	{
		array_push($errors, "MSG4");
	}else{
		if(!file_exists("modules/$module_name/$module_name.info"))
		{
			array_push($errors, "MSG6");
		}else{
			if(!file_exists("modules/$module_name/install.php"))
			{
				array_push($errors, "MSG9");
			}else{
				$req_by = $modules->get_requiredby($module_name);
				if(!empty($req_by))
				{
					array_push($errors, "MSG12");
				}
			}
		}
	}
	
	if(count($errors) < 1)
	{
		include("modules/$module_name/install.php");
		$module_info = $modules->get_module_info($module_name);
		$do_uninstall = uninstall();
		if(empty($do_uninstall))
		{
			$table = '<div class="message"><ul><li>'.str_replace("{MODULE}", $module_info["name"], MSG11).' <a href="'.url("admin/modules").'">['.BACK.']</a></li></ul></div>';
		}else{
			$module = $module_info;
			$table = $do_uninstall;
			$temp = $modules->load_template("modules/admin/modules.tpl");
			$table = eval("return '".$temp."';");
		}
	}else{
		$table = '<div class="message"><ul>';
		foreach($errors as $value)
		{
			$table = '<li>'.eval("return $value;").' <a href="'.url("admin/modules").'">['.BACK.']</a></li>';
			
			if($value == "MSG12")
			{
				$table = str_replace("{MODULES}", "<b>".($modules->get_requiredby($module_name))."</b>", $table);
			}
		}
		$table .= '</ul></div><br />';
	}
	
	$result = array("title" => MODULE_UNINSTALLATION, "head" => $modules->get_style("admin"), "content" => $table);
	return $result;
}

?>