<?php

class Modules
{
	function include_modules()
	{
		global $db;
		
		$run = array();
		$query = $db->select("name, include, eval", "modules", "ORDER BY id DESC");
		while($module = $db->fetch_array($query))
		{
			if($this->is_compatible($module["name"]))
			{
				get_include_contents("modules/".$module["name"]."/".$module["include"]);
				array_push($run, $module["eval"]);
			}
		}
		return $run;
	}
	
	function is_installed($module)
	{
		global $db;
		
		$module = query_filter($module);
		$query = $db->select("id", "modules", "WHERE name='$module'");
		if($module = $db->fetch_array($query))
		{
			return true;
		}else{
			return false;
		}
	}
	
	function is_compatible($module)
	{
		global $settings;
		
		$version = get_file_version("modules/$module/$module.info");
		$x_pos = strpos(strtolower($version), "x");
		if(!empty($x_pos))
		{
			$version = substr($version, 0, $x_pos);
			$settings_version = substr($settings["version"], 0, $x_pos);
		}
		
		if($version == $settings_version)
		{
			return true;
		}else{
			return false;
		}
	}
	
	function get_required_modules($module)
	{
		$info = $this->get_module_info($module);
		
		$req_mods["module"] = array();
		$req_mods["version"] = array();
		
		if(!empty($info["dependedon"]))
		{
			$explode = explode(",", $info["dependedon"]);
			foreach($explode as $key => $value)
			{
				array_push($req_mods["module"], substr($value, 0, strpos($value, "(")));
				array_push($req_mods["version"], substr($value, strpos($value, "(") + 1, strpos($value, ")") - strlen($value)));
			}
		}
		
		return $req_mods;
	}
	
	function are_req_mods_installed($module)
	{
		$req_mods = $this->get_required_modules($module);
		$installed = $this->get_installed_modules();
		
		$result = true;
		if(!empty($req_mods))
		{
			foreach($req_mods["module"] as $key => $value)
			{
				if(!in_array($value, $installed["module"]))
				{
					$result = false;
					break;
				}else{
					for($id=0; $id<count($installed["module"]); $id++)
					{
						if($installed["module"][$id] == $value)
						{
							break;
						}
					}
					if($req_mods["version"][$key] != $installed["version"][$id])
					{
						$result = false;
						break;
					}
				}
			}
		}
		return $result;
	}
	
	function insert_module($array)
	{
		global $db, $modules;
		
		$acceptable_inputs = array("id", "name", "include", "config", "eval");
		foreach($acceptable_inputs as $value)
		{
			if($value == "id")
			{
				$output = $array[$value];
				if($array[$value] != 0 or $array[$value] != 1)
				{
					$output = 1;
				}
			}
			$output = $array[$value];
			$module[$value] = query_filter($output);
		}
		unset($output);
		
		$insert = $db->insert("modules", "('".$module["id"]."', '".$module["name"]."', '".$module["include"]."', '".$module["config"]."', '".$module["eval"]."', '', '0')");
		
		if($insert)
		{
			$info = $this->get_module_info($module["name"]);
			if(!empty($info["dependedon"]))
			{
				$dep_on = explode(",", $info["dependedon"]);
				foreach($dep_on as $value)
				{	
					$req_mod = substr($value, 0, strpos($value, "("));
					$req_mod = query_filter($req_mod);
					$current_req = "";
					$req_by = $modules->get_requiredby($req_mod);
					if(!empty($req_by))
					{
						$current_req = $modules->get_requiredby($req_mod).",";
						$current_req = query_filter($current_req);
					}
					$db->update("modules", "requiredby='".$current_req.$module["name"]."' WHERE name='$req_mod'");
				}
			}
		}
	}
	
	function insert_block($array)
	{
		global $db;
		
		$acceptable_inputs = array("name", "title", "content", "area");
		foreach($acceptable_inputs as $value)
		{
			switch($value)
			{
				default;
					$output = $array[$value];
				break;
				
				case("area");
					$areas = array("left", "right", "content", "header", "footer");
					$output = $array[$value];
					if(!in_array($array[$value], $areas))
					{
						$output = $areas[0];
					}
				break;
			}
			$block[$value] = query_filter($output);
		}
		unset($output);
		
		$ids = get_list_of_ids("blocks", "WHERE area='".$block["area"]."'");
		
		$db->insert("blocks", "('".(max($ids) + 1)."', '".$block["name"]."', '".$block["title"]."', '".$block["content"]."', '".$block["area"]."', 'all', 'everyone', '0')");
	}
	
	function insert_content($array)
	{
		global $db;
		
		if(!empty($array["module"]))
		{
			$array["module"] = query_filter($array["module"]);
			$array["eval"] = query_filter($array["eval"]);
			$db->insert("contents", "('".$array["module"]."', '".$array["eval"]."')");
		}
	}
	
	function insert_head($array)
	{
		global $db;
		
		if(!empty($array["module"]))
		{
			$array["module"] = query_filter($array["module"]);
			$array["eval"] = query_filter($array["eval"]);
			$db->insert("head", "('".$array["module"]."', '".$array["eval"]."')");
		}
	}
	
	function insert_query($array)
	{
		global $db;
		
		$insert = "";
		$acceptable_inputs = array("module", "title", "query", "subset", "admin");
		foreach($array as $subarray)
		{
			foreach($acceptable_inputs as $value)
			{
				switch($value)
				{
					default;
						$output = $subarray[$value];
					break;
					
					case("subset");
						$output = $subarray[$value];
						if($subarray[$value] != 0 and $subarray[$value] != 1)
						{
							$output = 0;
						}
					break;
					
					case("admin");
						$output = $subarray[$value];
						if($subarray[$value] != 0 and $subarray[$value] != 1)
						{
							$output = 0;
						}
					break;
				}
				$query[$value] = query_filter($output);
			}
			$insert .= "('', '".$query["module"]."', '".$query["title"]."', '".$query["query"]."', '".$query["subset"]."', '".$query["admin"]."'), ";
			unset($query);
		}
		$insert = substr($insert, 0, strlen($insert)-2);
		$db->insert("queries", $insert);
	}
	
	function remove_module($module, $table)
	{
		global $db;
		
		$tables = array("blocks", "contents", "head", "modules", "queries", "shortcuts");
		if(in_array($table, $tables))
		{
			if($table == "blocks" or $table == "modules"){ $field = "name"; }else{ $field = "module"; }
			
			$module = query_filter($module);
			$delete = $db->delete($table, "WHERE $field='$module'");
			if($delete and $table == "modules")
			{
				$this->remove_from_requiredby($module);
			}
		}
	}
	
	function get_requiredby($module)
	{
		global $db;
		
		$module = query_filter($module);
		$query = $db->select("requiredby", "modules", "WHERE name='$module'");
		if($req_by = $db->fetch_array($query))
		{
			return $req_by["requiredby"];
		}
	}
	
	function remove_from_requiredby($module)
	{
		global $db;
		
		$installed = $this->get_installed_modules();
		
		foreach($installed["module"] as $mdl)
		{
			$mdl = query_filter($mdl);
			$query = $db->select("requiredby", "modules", "WHERE name='$mdl'");
			$result = false;
			$current_reqs = "";
			if($req_by = $db->fetch_array($query))
			{
				$reqs = explode(",", $req_by["requiredby"]);
				foreach($reqs as $value)
				{
					if($value == $module)
					{
						$result = true;
					}else{
						$current_reqs .= $value.",";
					}
				}
			}
			if($result == true)
			{
				$current_reqs = substr($current_reqs, 0, strlen($current_reqs)-1);
				$current_reqs = query_filter($current_reqs);
				$db->update("modules", "requiredby='$current_reqs' WHERE name='$mdl'");
			}
		}
	}
	
	function load_template($file, $eval = ";")
	{
		global $module, $settings;
		
		if($module["user"]->is_authorized())
		{
			$theme = $module["user"]->get_user_info("theme");
		}else{
			$theme = $settings["theme"];
		}
		
		$explode = explode("/", $file);
		$new_file = "themes/".$theme."/".$explode[1]."-".$explode[count($explode) - 1];
		if(file_exists($new_file))
		{
			$temp = get_include_contents($new_file, $eval);
		}else{
			$temp = get_include_contents($file, $eval);
		}
		$temp = str_filter("',{,},&#123;,&#125", "\\','.,.',{,}", $temp);
		return $temp;
	}
	
	function get_modules_list()
	{
		$modules_list = array();
		$dir = opendir("./modules");
		while($file = readdir($dir))
		{
			if($file != "." and $file != "..")
			{
				array_push($modules_list, $file);
			}
		}
		closedir($dir);
		return $modules_list;
	}
	
	function get_module_info($module)
	{
		$file = "modules/$module/$module.info";
		$open = fopen($file, "r");
		$contents = fread($open, filesize($file));
		$line = explode("\n", $contents);
		$info = array();
		for($i=2; $i<count($line); $i++)
		{
			$item = explode(" = ", $line[$i]);
			$info[$item[0]] = trim($item[1]);
		}
		fclose($open);
		$info["module"] = $module;
		return $info;
	}
	
	function get_installed_modules($type = "all", $optional_query = "")
	{
		global $db;
		
		$installed["module"] = array();
		$installed["version"] = array();
		
		$query = $db->select("name", "modules", $optional_query."ORDER BY name");
		while($mdl = $db->fetch_array($query))
		{
			$info = $this->get_module_info($mdl["name"]);
			
			if($type == "all")
			{
				array_push($installed["module"], $mdl["name"]);
				array_push($installed["version"], $info["version"]);
			}elseif($type == "core"){
				if($info["type"] == "Core")
				{
					array_push($installed["module"], $mdl["name"]);
					array_push($installed["version"], $info["version"]);
				}
			}elseif($type == "optional"){
				if($info["type"] == "Optional")
				{
					array_push($installed["module"], $mdl["name"]);
					array_push($installed["version"], $info["version"]);
				}
			}
		}
		return $installed;
	}
	
	function include_language($module, $file = "")
	{
		$info = $this->get_module_info($module);
		
		if($info["type"] == "Core")
		{
			global $page;
			include("languages/".$page["language"]."/$module.php");
		}elseif($info["type"] == "Optional"){
			if(empty($file))
			{
				global $page;
				$file = $page["language"].".php";
			}
			
			if(file_exists("modules/$module/lang/$file"))
			{
				include("modules/$module/lang/$file");
			}
		}
	}
	
	function get_style($module_name, $file = "style.css")
	{
		global $lang, $module, $settings;
		
		if($lang["direction"] == "rtl")
		{
			$file = str_replace(".", "-rtl.", $file);
		}
		
		if($module["user"]->is_authorized())
		{
			$theme = $module["user"]->get_user_info("theme");
		}else{
			$theme = $settings["theme"];
		}
		
		$new_file = "themes/".$theme."/".$module_name."-".$file;
		if(file_exists($new_file))
		{
			$style = $new_file;
		}else{
			$style = "modules/".$module_name."/".$file;
		}
		
		return '<link rel="stylesheet" href="'.base_path().'/'.$style.'" type="text/css" />';
	}
	
	function get_update_info($contents)
	{
		$line = explode("\n", $contents);
		$info = array();
		for($i=2; $i<count($line); $i++)
		{
			$item = explode(" = ", $line[$i]);
			$info[$item[0]] = trim($item[1]);
		}
		return $info;
	}
	
	function get_update_version($contents)
	{
		$line = explode("\n", $contents);
		if(substr($line[0], 0, 2) == "//")
		{
			$id = 0;
		}elseif(substr($line[1], 0, 2) == "//"){
			$id = 1;
		}
		$info = explode(",", $line[$id]);
		return trim($info[1]);
	}
	
	function administration($module)
	{
		$file = "modules/$module/admin.php";
		if(file_exists($file))
		{
			include($file);
			if(function_exists("administration"))
			{
				return administration();
			}
		}
	}
}

?>