<?php

function get_include_contents($file, $eval = ";")
{
	eval($eval);
	
	ob_start();
	include($file);
	$contents = ob_get_contents();
	ob_end_clean();
	return $contents;
}

function start_session_now()
{
	$session_id = session_id();
	if(empty($session_id))
	{
		session_name("_limny");
		session_start();
	}
}

function str_filter($filter, $to, $str)
{
	$filter = explode(",", $filter);
	$to = explode(",", $to);
	
	foreach($filter as $key => $value)
	{
		$str = str_replace("".$value."", $to[$key], $str);
	}
	return $str;
}

function get_time_difference($start, $end = 0)
{
	$i = 0;
	$inverse = 0;
	
	$units = array("second" => 60, "minute" => 60, "hour" => 24, "day" => 30, "month" => 12, "year" => 365);
	$start_chr = array(17, 14, 11, 8, 5, 0);
	$chrs_length = array(2, 2, 2, 2, 2, 4);
	
	if($end == 0)
	{
		$end = date("Y-m-d H:i:s");
	}
	
	foreach($units as $unit => $length)
	{
		$from[$unit] = substr($start, $start_chr[$i], $chrs_length[$i]);
		$to[$unit] = substr($end, $start_chr[$i], $chrs_length[$i]);
		$i++;
	}
	
	foreach($units as $unit => $length)
	{
		$dif[$unit] = $inverse + $to[$unit] - $from[$unit];
		$inverse = 0;
		if($dif[$unit] < 0)
		{
			$dif[$unit] = ($length - $from[$unit]) + $to[$unit];
			$inverse = -1;
		}
	}
	
	return $dif;
}

function get_list_of_ids($table, $arguments = "")
{
	global $db;
	
	$ids = array();
	$query = $db->select("id", $table, $arguments);
	while($id = $db->fetch_array($query))
	{
		array_push($ids, $id["id"]);
	}
	
	return $ids;
}

function reset_ids($table, $arguments = "")
{
	global $db;
	
	$ids = array();
	$i = 0;
	$query = $db->select("id", $table, $arguments);
	while($item = $db->fetch_array($query))
	{
		$ids[$i] = $item["id"];
		$i++;
	}
	
	if(count($ids) > 1)
	{
		foreach($ids as $key => $value)
		{
			$db->update($table, "id='".($key + 1)."' WHERE id='$value'");
		}
	}
}

function base_path()
{
	$base_path = dirname($_SERVER["SCRIPT_NAME"]);
	if($base_path != "/")
	{
		return $base_path;
	}
}

function url($q, $full_url = 0, $inc_lang = 1)
{
	global $module, $settings;
	
	$current_language = $module["language"]->get_language();
	if($inc_lang == 1 and !empty($current_language))
	{
		$q = $current_language."/".$q;
	}
	
	$indexphp = "";
	if($settings["urltype"] == "full")
	{
		if($settings["byindexphp"] == 1)
		{
			$indexphp = "index.php";
		}
		$q = "$indexphp?q=$q";
	}
	
	if($full_url == 0)
	{
		return base_path()."/".$q;
	}else{
		return $settings["site"]."/".$q;
	}
}

function get_file_version($file)
{
	$open = fopen($file, "r");
	$contents = fread($open, filesize($file));
	$line = explode("\n", $contents);
	if(substr($line[0], 0, 2) == "//")
	{
		$id = 0;
	}
	elseif(substr($line[1], 0, 2) == "//")
	{
		$id = 1;
	}
	$info = explode(",", $line[$id]);
	fclose($open);
	return trim($info[1]);
}

function is_refered_from($url)
{
	global $db;
	
	$query = $db->select("shortcut", "shortcuts", "WHERE source='$url'");
	if($db->num_rows($query) > 0 and $content = $db->fetch_array($query))
	{
		$shortcut = $content["shortcut"];
	}else{
		$shortcut = "";
	}
	$referer = @$_SERVER["HTTP_REFERER"];
	if($referer == url($url, 1) or $referer == url($shortcut, 1))
	{
		return true;
	}else{
		return false;
	}
}

function query_filter($str)
{
	if(!get_magic_quotes_gpc())
	{
		$str = addslashes($str);
	}
	
	return $str;
}

function get_settings()
{
	global $db;
	
	$query = $db->select("*", "settings");
	while($item = $db->fetch_array($query))
	{
		$settings[$item["name"]] = $item["value"];
	}
	
	return $settings;
}

function get_query($q = "")
{
	global $module;
	
	if(empty($q))
	{
		$q = @$_GET["q"];
	}
	
	$q = explode("/", $q);
	$languages_list = $module["language"]->get_languages_list("installed");
	
	if(strlen($q[0]) == 2 and in_array($q[0], $languages_list))
	{
		unset($q[0]);
		$q = array_merge(array(), $q);
	}
	
	return $q;
}

function def($name, $value, $case_insensitive = false)
{
	if(!defined($name))
	{
		define($name, $value, $case_insensitive);
	}
}

?>