CREATE TABLE IF NOT EXISTS `lmn_blocks` (
  `id` tinyint(4) NOT NULL,
  `name` varchar(64) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `area` varchar(64) NOT NULL,
  `language` varchar(256) NOT NULL,
  `usergroup` varchar(128) NOT NULL,
  `edit` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_blocks` (`id`, `name`, `title`, `content`, `area`, `language`, `usergroup`, `edit`) VALUES
(1, 'Header', '', '<?php $settings = $GLOBALS["settings"]; return get_include_contents("themes/".$settings["theme"]."/header.php", ''$settings = $GLOBALS["settings"];''); ?>', 'header', 'all', 'everyone', 0),
(1, 'Footer', '', '<?php $settings = $GLOBALS["settings"]; return get_include_contents("themes/".$settings["theme"]."/footer.php", ''$settings = $GLOBALS["settings"];''); ?>', 'footer', 'all', 'everyone', 0),
(1, 'Content', '', '<?php $module = $GLOBALS["module"]; return $module["content"]->get_content(); ?>', 'content', 'all', 'everyone', 0),
(1, 'User', '<?php $module = $GLOBALS["module"]; return $module["user"]->user_block_title(); ?>', '<?php $module = $GLOBALS["module"]; return $module["user"]->user_block(); ?>', 'left', 'all', 'everyone', 0),
(1, 'Language', '<?php $module = $GLOBALS["module"]; return $module["language"]->language_block_title(); ?>', '<?php $module = $GLOBALS["module"]; $block["language"]["title"] = $module["language"]->language_block_title(); return $module["language"]->language_block(); ?>', 'right', 'all', 'everyone', 0),
(2, 'Navigation', '', '<?php $module = $GLOBALS["module"]; return $module["navigation"]->navigation(); ?>', 'header', 'all', 'everyone', 0);

CREATE TABLE IF NOT EXISTS `lmn_changeemail` (
  `id` tinyint(9) NOT NULL AUTO_INCREMENT,
  `user` varchar(64) NOT NULL,
  `email` varchar(128) NOT NULL,
  `code` varchar(32) NOT NULL,
  `expire` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `lmn_content` (
  `name` varchar(64) NOT NULL,
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_content` (`name`, `value`) VALUES
('default', 'query'),
('module', 'admin'),
('query', 'page/1'),
('code', '<h2>Limny</h2>This is the default page of content module. Please go to Content module administration to edit this page.'),
('pagenotfounderror', '<h2>404 Page not found</h2>\r\n<br />\r\nThe page that you are trying to view does not exists.'),
('shortcut', '1'),
('shortcuttype', 'include');

CREATE TABLE IF NOT EXISTS `lmn_contents` (
  `module` varchar(64) NOT NULL,
  `eval` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_contents` (`module`, `eval`) VALUES
('user', '$module = $GLOBALS["module"]; return $module["user"]->user_pages($q);'),
('admin', '$module = $GLOBALS["module"]; return $module["admin"]->admin_pages($q);'),
('page', '$module = $GLOBALS["module"]; return $module["page"]->page_pages($q);');

CREATE TABLE IF NOT EXISTS `lmn_forgotpw` (
  `id` tinyint(9) NOT NULL AUTO_INCREMENT,
  `user` varchar(64) NOT NULL,
  `email` varchar(128) NOT NULL,
  `code` varchar(32) NOT NULL,
  `expire` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `lmn_head` (
  `module` varchar(64) NOT NULL,
  `eval` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_head` (`module`, `eval`) VALUES
('user', '$module = $GLOBALS["module"]; return $module["user"]->load_menu_style();'),
('navigation', '$module = $GLOBALS["module"]; return $module["navigation"]->load_nav_style();');

CREATE TABLE IF NOT EXISTS `lmn_languages` (
  `id` tinyint(4) NOT NULL,
  `key` varchar(2) NOT NULL,
  `name` varchar(64) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_languages` (`id`, `key`, `name`) VALUES
(1, 'en', 'English');

CREATE TABLE IF NOT EXISTS `lmn_menu` (
  `id` tinyint(4) NOT NULL,
  `name` varchar(64) NOT NULL,
  `title` varchar(64) NOT NULL,
  `href` text NOT NULL,
  `target` varchar(64) NOT NULL,
  `onclick` varchar(64) NOT NULL,
  `language` varchar(256) NOT NULL,
  `usergroup` varchar(128) NOT NULL,
  `edit` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_menu` (`id`, `name`, `title`, `href`, `target`, `onclick`, `language`, `usergroup`, `edit`) VALUES
(1, 'Home', 'Home page', '[q=]', '_self', '', 'all', 'everyone', 1),
(2, 'My account', 'My account', '[q=user]', '_self', '', 'all', 'everyone', 1),
(3, 'Administration', 'Administration', '[q=admin]', '_self', '', 'all', '1,2', 1),
(4, 'Logout', 'Logout', '[q=user/logout]', '_self', '', 'all', 'everyone', 0);

CREATE TABLE IF NOT EXISTS `lmn_modules` (
  `id` tinyint(4) NOT NULL,
  `name` varchar(64) NOT NULL,
  `include` varchar(64) NOT NULL,
  `config` text NOT NULL,
  `eval` text NOT NULL,
  `requiredby` text NOT NULL,
  `core` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_modules` (`id`, `name`, `include`, `config`, `eval`, `requiredby`, `core`) VALUES
(7, 'user', 'user.php', '$modules = $GLOBALS["modules"]; return $modules->administration("user");', '$module["user"] = new User; if($module["user"]->is_authorized()){ $page["language"] = $module["user"]->get_user_language(); $settings["theme"] = $module["user"]->get_user_info("theme"); };', '', 1),
(6, 'content', 'content.php', '$modules = $GLOBALS["modules"]; return $modules->administration("content");', '$module["content"] = new Content;', '', 1),
(9, 'language', 'language.php', '$modules = $GLOBALS["modules"]; return $modules->administration("language");', '$module["language"] = new Language; $page["language"] = $module["language"]->get_language(); if(empty($page["language"])){ $page["language"] = $settings["language"]; }', '', 1),
(5, 'admin', 'admin.php', '$module = $GLOBALS["module"]; return $module["admin"]->admin_admin();', '$module["admin"] = new Admin;', '', 1),
(8, 'usergroup', 'usergroup.php', '$modules = $GLOBALS["modules"]; return $modules->administration("usergroup");', '$module["usergroup"] = new Usergroup;', '', 1),
(4, 'block', 'block.php', '$modules = $GLOBALS["modules"]; return $modules->administration("block");', '$module["block"] = new Block;', '', 1),
(1, 'nicedit', 'nicedit.php', '', '$module["nicedit"] = new NicEdit;', '', 0),
(3, 'theme', 'theme.php', '$modules = $GLOBALS["modules"]; return $modules->administration("theme");', '$module["theme"] = new Theme;', '', 1),
(2, 'widget', 'widget.php', '$module["widget"] = new Widget; return $module["widget"]->widget();', '', '', 1),
(1, 'page', 'page.php', '$modules = $GLOBALS["modules"]; return $modules->administration("page");', '$module["page"] = new Page;', '', 0),
(1, 'navigation', 'navigation.php', '$modules = $GLOBALS["modules"]; return $modules->administration("navigation");', '$module["navigation"] = new Navigation;', '', 0);

CREATE TABLE IF NOT EXISTS `lmn_navigation` (
  `id` tinyint(4) NOT NULL,
  `name` varchar(64) NOT NULL,
  `title` varchar(64) NOT NULL,
  `href` text NOT NULL,
  `target` varchar(64) NOT NULL,
  `onclick` varchar(64) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_navigation` (`id`, `name`, `title`, `href`, `target`, `onclick`) VALUES
(1, 'Home', 'Home page', '[q=]', '_self', '');

CREATE TABLE IF NOT EXISTS `lmn_page` (
  `name` varchar(64) NOT NULL,
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_page` (`name`, `value`) VALUES
('pageslinksby', 'shortcut'),
('datetimetype', 'D, d/m/Y - h:m'),
('itemsseperator', ' - '),
('managemodules', ''),
('manageitems', '');

CREATE TABLE IF NOT EXISTS `lmn_pages` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `content` text NOT NULL,
  `created` varchar(64) NOT NULL,
  `shortcut` tinyint(4) NOT NULL,
  `language` varchar(256) NOT NULL,
  `usergroup` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `lmn_pages` (`id`, `title`, `content`, `created`, `shortcut`, `language`, `usergroup`) VALUES
(1, 'Congratulations', '<br /><span style="font-family:verdana;">Limny installed successfully!</span><br /><br /><table style="width:100%;text-align:center;">\r\n<tbody><tr>\r\n<td valign="top"><img alt="settings" src="modules/admin/icon" /><br /><a href="?q=admin/settings">1. Update your settings</a></td><td valign="top"><img alt="page" src="modules/page/icon" /><br /><a href="?q=admin/modules/page">2. Create your own pages</a></td><td valign="top"><img alt="addons" src="misc/module.png" /><br /><a href="http://www.limny.org/project">3. Customize it using addons</a></td>\r\n</tr>\r\n</tbody></table><br /><br /><br /><br /><br /><span style="font-family:verdana;color:gray;">You can modify your default content in <a href="?q=admin/modules/content">Content</a> module options. Also you can modify this page in <a href="?q=admin/modules/page/list">Page</a> module.</span><br />', '1270734388', 1, 'all', 'everyone');

CREATE TABLE IF NOT EXISTS `lmn_pagestemp` (
  `id` tinyint(4) NOT NULL,
  `area` varchar(64) NOT NULL,
  `module` varchar(64) NOT NULL,
  `title` varchar(64) NOT NULL,
  `eval` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_pagestemp` (`id`, `area`, `module`, `title`, `eval`) VALUES
(1, 'topleft', 'page', 'Title', '$module = $GLOBALS["module"]; $options = $module["page"]->get_options(); $href = "page/".$page["id"]; if($options["pageslinksby"] == "shortcut" and $page["shortcut"] == "1"){ $href = $module["page"]->get_shortcut($page["id"]); } return ''<span class="title"><a href="''.url($href).''" title="''.$page["title"].''">''.$page["title"].''</a></span>'';'),
(1, 'topright', 'page', 'Date', '$module = $GLOBALS["module"]; return ''<span class="date">''.($module["page"]->print_date($page["created"])).''</span>'';'),
(1, 'center', 'page', 'Text', 'return $page["content"];');

CREATE TABLE IF NOT EXISTS `lmn_queries` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `module` varchar(64) NOT NULL,
  `title` varchar(64) NOT NULL,
  `query` varchar(256) NOT NULL,
  `subset` tinyint(4) NOT NULL,
  `admin` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=63 ;

INSERT INTO `lmn_queries` (`id`, `module`, `title`, `query`, `subset`, `admin`) VALUES
(1, 'admin', 'ADMINISTRATION', 'admin', 0, 0),
(2, 'admin', 'MODULES', 'admin/modules', 0, 1),
(3, 'admin', 'SETTINGS', 'admin/settings', 0, 1),
(4, 'admin', 'INSTALL_UPDATE', 'admin/update', 1, 0),
(5, 'admin', 'UPDATES', 'admin/updates', 0, 1),
(6, 'admin', 'INSTALL_MODULE', 'admin/modules/install', 1, 0),
(7, 'admin', 'UNINSTALL_MODULE', 'admin/modules/uninstall', 1, 0),
(8, 'block', 'NEW_BLOCK', 'admin/modules/block/new', 0, 1),
(9, 'block', 'BLOCKS', 'admin/modules/block', 0, 1),
(10, 'block', 'CHANGE_BLOCKS_AREA', 'admin/modules/block/area', 1, 0),
(11, 'block', 'CHANGE_BLOCKS_ORDER', 'admin/modules/block/order', 1, 0),
(12, 'block', 'EDIT_BLOCK', 'admin/modules/block/config', 1, 0),
(13, 'block', 'DELETE_BLOCK', 'admin/modules/block/delete', 1, 0),
(14, 'content', 'SETTINGS', 'admin/modules/content', 0, 1),
(15, 'content', 'SHORTCUTS', 'admin/modules/content/shortcut', 0, 1),
(16, 'content', 'NEW_SHORTCUT', 'admin/modules/content/shortcut/new', 0, 0),
(17, 'content', 'EDIT_SHORTCUT', 'admin/modules/content/shortcut/edit', 1, 0),
(18, 'content', 'DELETE_SHORTCUT', 'admin/modules/content/shortcut/delete', 1, 0),
(19, 'language', 'LANGUAGES', 'admin/modules/language', 0, 1),
(20, 'language', 'LANGUAGE_INFORMATION', 'admin/modules/language/info', 1, 0),
(21, 'language', 'CHANGE_LANGUAGES_ORDER', 'admin/modules/language/order', 1, 0),
(22, 'language', 'INSTALL_LANGUAGE', 'admin/modules/language/install', 1, 0),
(23, 'language', 'UNINSTALL_LANGUAGE', 'admin/modules/language/uninstall', 1, 0),
(24, 'theme', 'THEMES', 'admin/modules/theme', 0, 1),
(25, 'theme', 'INSTALL_THEME', 'admin/modules/theme/install', 1, 0),
(26, 'theme', 'UNINSTALL_THEME', 'admin/modules/theme/uninstall', 1, 0),
(27, 'user', 'USERS', 'admin/modules/user', 0, 0),
(28, 'user', 'NEW_USER', 'admin/modules/user/new', 0, 1),
(29, 'user', 'EDIT_USER', 'admin/modules/user/edit', 1, 0),
(30, 'user', 'DELETE_USER', 'admin/modules/user/delete', 1, 0),
(31, 'user', 'USERS_LIST', 'admin/modules/user/list', 0, 1),
(32, 'user', 'USERS_OPTIONS', 'admin/modules/user/options', 0, 1),
(33, 'user', 'USERS_PROFILE', 'user', 0, 0),
(34, 'user', 'MENU', 'admin/modules/user/menu', 0, 1),
(35, 'user', 'ADD_MENU_ITEM', 'admin/modules/user/menu/new', 1, 0),
(36, 'user', 'CHANGE_ORDERS_OF_MENU_ITEMS', 'admin/modules/user/menu/order', 1, 0),
(37, 'user', 'EDIT_MENU_ITEMS', 'admin/modules/user/menu/edit', 1, 0),
(38, 'user', 'WEBSITE_LINKS', 'admin/modules/user/menu/links', 0, 0),
(39, 'user', 'DELETE_MENU_ITEMS', 'admin/modules/user/menu/delete', 1, 0),
(40, 'usergroup', 'USERGROUPS', 'admin/modules/usergroup', 0, 1),
(41, 'usergroup', 'NEW_USERGROUP', 'admin/modules/usergroup/new', 0, 0),
(42, 'usergroup', 'EDIT_USERGROUP', 'admin/modules/usergroup/edit', 1, 0),
(43, 'usergroup', 'DELETE_USERGROUP', 'admin/modules/usergroup/delete', 1, 0),
(44, 'usergroup', 'CHANGE_USERGROUPS_PERMISSIONS', 'admin/modules/usergroup/permissions', 1, 0),
(45, 'widget', 'WIDGETS', 'admin/modules/widget', 0, 1),
(46, 'widget', 'INSTALL_WIDGET', 'admin/modules/widget/install', 1, 0),
(47, 'widget', 'UNINSTALL_WIDGET', 'admin/modules/widget/uninstall', 1, 0),
(48, 'widget', 'DOWNLOAD_WIDGET', 'admin/modules/widget/download', 1, 0),
(49, 'navigation', 'NAVIGATION', 'admin/modules/navigation', 0, 1),
(50, 'navigation', 'NEW_ITEM', 'admin/modules/navigation/new', 0, 0),
(51, 'navigation', 'EDIT_ITEM', 'admin/modules/navigation/edit', 1, 0),
(52, 'navigation', 'CHANGE_ITEMS_ORDER', 'admin/modules/navigation/order', 1, 0),
(53, 'navigation', 'DELETE_ITEM', 'admin/modules/navigation/delete', 1, 0),
(54, 'page', 'PAGES', 'admin/modules/page', 0, 0),
(55, 'page', 'NEW_PAGE', 'admin/modules/page/new', 0, 1),
(56, 'page', 'PAGES_LIST', 'admin/modules/page/list', 0, 1),
(57, 'page', 'EDIT_PAGE', 'admin/modules/page/edit', 1, 0),
(58, 'page', 'DELETE_PAGE', 'admin/modules/page/delete', 1, 0),
(59, 'page', 'TEMPLATE', 'admin/modules/page/template', 0, 1),
(60, 'page', 'CHANGE_TEMPLATES_ITEMS_AREA', 'admin/modules/page/template/area', 1, 0),
(61, 'page', 'CHANGE_TEMPLATES_ITEMS_ORDER', 'admin/modules/page/template/order', 1, 0),
(62, 'page', 'PAGES_OPTIONS', 'admin/modules/page/options', 0, 1);

CREATE TABLE IF NOT EXISTS `lmn_settings` (
  `name` varchar(64) NOT NULL,
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_settings` (`name`, `value`) VALUES
('title', 'Limny'),
('theme', 'dark'),
('language', 'en'),
('site', 'http://www.limny.org'),
('email', 'noreply@limny.org'),
('header', 'Limny'),
('footer', 'Copyright &copy; 2010'),
('titleseperator', ' | '),
('urltype', 'full'),
('byindexphp', ''),
('version', '2.2');

CREATE TABLE IF NOT EXISTS `lmn_shortcuts` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `module` varchar(64) NOT NULL,
  `source` varchar(256) NOT NULL,
  `shortcut` varchar(256) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `lmn_shortcuts` (`id`, `module`, `source`, `shortcut`) VALUES
(1, 'page', 'page/1', 'get-started-with-limny');

CREATE TABLE IF NOT EXISTS `lmn_signup` (
  `id` tinyint(9) NOT NULL AUTO_INCREMENT,
  `user` varchar(64) NOT NULL,
  `email` varchar(128) NOT NULL,
  `code` varchar(32) NOT NULL,
  `expire` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `lmn_themes` (
  `id` tinyint(4) NOT NULL,
  `name` varchar(64) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_themes` (`id`, `name`) VALUES
(2, 'gray'),
(1, 'dark');

CREATE TABLE IF NOT EXISTS `lmn_user` (
  `name` varchar(64) NOT NULL,
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_user` (`name`, `value`) VALUES
('signup', '1'),
('emailconfirm', '1'),
('editablefields', 'pass,theme,language,email,picture'),
('pictureexts', 'jpg,jpeg,gif,png'),
('picturemaxsize', '150x150'),
('picturemaxfilesize', '15000'),
('defaultusergroup', '3'),
('welcomeemailsubject', 'Welcome'),
('welcomeemailmessage', '{USERNAME}\r\n\r\nYour registration in {SITE} is done successfully.\r\n\r\nUsername: {USERNAME}\r\nPassword: {PASSWORD}\r\n\r\nYou may now login by clicking on this link:\r\n\r\n{LOGIN_URL}'),
('activationemailsubject', 'Activation'),
('activationemailmessage', '{USERNAME}\r\n\r\nYou or another one has used this email to registering in {SITE}. Please continue registration by clicking on this link:\r\n\r\n{ACTIVATION_URL}'),
('passwordrecoveryemailsubject', 'Password recovery'),
('passwordrecoveryemailmessage', '{USERNAME}\r\n\r\nA password reset for this account has been made from {SITE}. Please continue operation by clicking on this link:\r\n\r\n{PASSWORDRESET_URL}'),
('changeemailsubject', 'Change email'),
('changeemailmessage', '{USERNAME}\r\n\r\nYou or another one changed email address in {SITE} to this one. Please continue operation by clicking on this link:\r\n\r\n{ACTIVATION_URL}');

CREATE TABLE IF NOT EXISTS `lmn_usergroups` (
  `id` tinyint(4) NOT NULL,
  `name` varchar(64) NOT NULL,
  `permissions` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `lmn_usergroups` (`id`, `name`, `permissions`) VALUES
(1, 'Administrator', 'all'),
(2, 'Moderator', '1,8,9,10,11,12,13,33,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62'),
(3, 'User', '33');

CREATE TABLE IF NOT EXISTS `lmn_users` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `user` varchar(64) NOT NULL,
  `pass` varchar(64) NOT NULL,
  `email` varchar(128) NOT NULL,
  `picture` varchar(128) NOT NULL,
  `language` varchar(64) NOT NULL,
  `theme` varchar(64) NOT NULL,
  `signedup` varchar(64) NOT NULL,
  `signedin` varchar(64) NOT NULL,
  `ipaddr` varchar(32) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `usergroup` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `lmn_users` (`id`, `user`, `pass`, `email`, `picture`, `language`, `theme`, `signedup`, `signedin`, `ipaddr`, `status`, `usergroup`) VALUES
(1, 'admin', '21232f297a57a5a743894a0e4a801fc3', 'noreply@limny.org', '', 'en', 'dark', '1267170375', '', '127.0.0.1', 1, 1);

CREATE TABLE IF NOT EXISTS `lmn_widgets` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `version` varchar(32) NOT NULL,
  `xml` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;